program dw03; {Nyeremenyjatek - DW c2003}

uses crt;

type
    tadat = record
      kategoria : char;
      sorszam   : word;
      nyerte    : boolean;
      torolvee  : boolean;
      szam      : string[100];
    end;

const
     c1 = green; {Betuszin}
     c2 = lightcyan;       {Controllszin}
     c3 = lightgreen;     {Fontosszin}
     c4 = black;     {Hatterszin}

var
   adatok       : file of tadat;
   adat         : tadat;
   kategoriax   : char;

procedure vanfile;
  begin
    assign(adatok,'nyszamok.dat');
    {$I-} reset(adatok); {$I+}
    if ioresult = 0 then writeln('A file ltezik!(0)')
      else
        begin
          rewrite(adatok);
          writeln('A file ltrehozva!(1)');
        end;
    close(adatok);
  end;

procedure kategoriaki;
  begin
    case kategoriax of
      '1' : begin textcolor(c3); write(' 5.000'); textcolor(c1); end;
      '2' : begin textcolor(c3); write('10.000'); textcolor(c1); end;
      '3' : begin textcolor(c3); write('20.000'); textcolor(c1); end;
      '4' : begin textcolor(c3); write('50.000'); textcolor(c1); end;
      #27 : begin textcolor(c3); write('Kilp.'); textcolor(c1); end;
      else  begin textcolor(c3); write('Nincs.'); textcolor(c1); end;
    end;
  end;

procedure alapkepernyo;
  begin
    clrscr;
    writeln;{..1234567890123456789012345678901234567890}
    writeln;
    writeln;
    writeln('                    NYEREMNYJTK             ');
    writeln('                    ~~~~~~~~~~~~~~             ');
    writeln;
    write('  Kategria: '); kategoriaki; write('               ');
    textcolor(c2); write('ESC'); textcolor(c1); writeln(' - Kilps');
    writeln;
    writeln;
  end;

procedure kategoria;
  begin
    kategoriax := '0';
    alapkepernyo;
    write('     '); textcolor(c2); write('1'); textcolor(c1); write(' -  5.000     ');
    textcolor(c2); write('2'); textcolor(c1); writeln(' - 10.000');
    writeln;
    write('       '); textcolor(c2); write('3'); textcolor(c1); write(' - 20.000     ');
    textcolor(c2); write('4'); textcolor(c1); writeln(' - 50.000');
    writeln;
    writeln;
    write('  Melyik kategrit vlasztja? '); kategoriax := readkey;
    case kategoriax of
      '1' : write('1');
      '2' : write('2');
      '3' : write('3');
      '4' : write('4');
      #27 : write('ESC');
      else
        begin
          textcolor(c2);
          write('1 - 4 vagy ESC(Kilps)');
          textcolor(c1);
          delay(1500);
          kategoria;
        end;
    end;
  end;

procedure modosit2;
  var
     modszam               : string[100];
     talalte,sikerx,rossze : boolean;
     ujkerszamx,modosit2x  : char;
     k                     : word;
  begin
    assign(adatok,'nyszamok.dat');
    reset(adatok);
    repeat
      seek(adatok,0);
      modosit2x := '0';
      talalte := false;
      sikerx := false;
      alapkepernyo;
      writeln('  Krem a szmot amit majd mdostani ill. trlni akar : ');
      writeln;
      writeln;
      write('                    ');
      textcolor(c2); readln(modszam); textcolor(c1);
      writeln;
      writeln;
      for k := 1 to filesize(adatok) do
        begin
          read(adatok,adat);
          talalte := modszam = adat.szam;
          if talalte = true then
            if kategoriax = adat.kategoria then
              if adat.torolvee = false then
                begin
                  write('  ');
                  if adat.nyerte = true then
                    begin
                      textcolor(c3); write('NYERT'); textcolor(c1);
                    end
                    else write('     ');
                  writeln('     ',adat.szam);
                  writeln;
                  writeln;
                  write('  '); textcolor(c2); write('1'); textcolor(c1); writeln(' - A szm trlse');
                  writeln;
                  write('    '); textcolor(c2); write('2'); textcolor(c1); writeln(' - A szm mdostsa');
                  writeln;
                  if adat.nyerte = true then
                    begin
                      write('      '); textcolor(c2); write('3'); textcolor(c1); writeln(' - Mgsem nyert ez a szm')
                    end
                    else
                      begin
                        write('      '); textcolor(c2); write('3'); textcolor(c1); writeln('- A szm nyert');
                      end;
                  writeln;
                  writeln;
                  write('  Melyiket vlasztja? '); modosit2x := readkey;
                  repeat
                    rossze := false;
                    case modosit2x of
                      '1' : begin
                              writeln;
                              writeln;
                              writeln;
                              write('  Biztos benne, hogy trli a szmot? ( ');
                                textcolor(c2); write('ENTER'); textcolor(c1); write(' - Igen )');
                              modosit2x := readkey;
                              writeln;
                              writeln;
                              if modosit2x = #13 then
                                begin
                                  adat.torolvee := true;
                                  writeln('  A szm trlve!');
                                end
                                else writeln('  Nem trtnt trls!');
                            end;
                      '2' :  begin
                               writeln;
                               writeln;
                               writeln;
                               writeln('  Krem a szmot amire a rgit mdostja :');
                               writeln;
                               writeln;
                               write('                    '); textcolor(c2); readln(adat.szam); textcolor(c1);
                               writeln;
                               writeln;
                               writeln('  A szm mdostva!');
                             end;
                      '3' :  begin
                               writeln;
                               writeln;
                               writeln;
                               if adat.nyerte = true then
                                 begin
                                   adat.nyerte := false;
                                   writeln('  A szm nem nyert!');
                                 end
                                 else
                                   begin
                                     adat.nyerte := true;
                                     writeln('  A szm nyert!');
                                   end;
                             end;
                      #27 : writeln('ESC');
                      else
                        begin
                          rossze := true;
                          textcolor(c2); write('1 - 3 vagy ESC(Kilps)'); textcolor(c1);
                          delay(1500);
                          gotoxy(wherex - 23,wherey);
                          clreol;
                          modosit2x := readkey;
                        end;
                    end;
                  until rossze = false;
                  seek(adatok,filepos(adatok) - 1);
                  write(adatok,adat);
                  sikerx := true;
                end;
        end;
      if sikerx <> true then
        begin
          write('  A szm a(z) '); kategoriaki; writeln('-s kategriban nem tallhat!');
        end;
      writeln;
      writeln;
      write('  Kvn megadni j szmot ( ');
        textcolor(c2); write('ENTER'); textcolor(c1); write('-Igen / ');
        textcolor(c2); write('Brmely ms lets'); textcolor(c1); write('-Nem ) ? ');
      ujkerszamx := readkey;
    until ujkerszamx <> #13;
    close(adatok);
  end;

procedure modosit1;
  var
     modosit1x : char;
     i         : word;
  begin
    alapkepernyo;
    write('  Biztos benne, hogy trli a mr nyert szmokat? (');
      textcolor(c2); write('ENTER'); textcolor(c1); write(' - Igen) ');
    modosit1x := readkey;
    writeln;
    writeln;
    writeln;
    if modosit1x = #13 then
      begin
        assign(adatok,'nyszamok.dat');
        reset(adatok);
        for i := 1 to filesize(adatok) do
          begin
            read(adatok,adat);
            if adat.nyerte = true then
              if kategoriax = adat.kategoria then
                begin
                  if adat.torolvee = false then
                    begin
                      write('  ',adat.szam,'    '); textcolor(c2); writeln('TRLVE'); textcolor(c1);
                    end;
                  adat.torolvee := true;
                  seek(adatok,filepos(adatok) - 1);
                  write(adatok,adat);
                end;
          end;
        close(adatok);
        writeln;
        writeln('  A trls megtrtnt!');
      end
      else writeln('  Nem trtnt trls!');
    readkey;
  end;

procedure modosit;
  var
     modositx : char;
  begin
    alapkepernyo;
    write('  '); textcolor(c2); write('1'); textcolor(c1); write(' - Az sszes mr NYERT szm kitrlse a(z) ');
      kategoriaki; writeln('-es kategrin bell!');
    writeln;
    write('    '); textcolor(c2); write('2'); textcolor(c1); writeln(' - Egy megadott szm kitrlse ill. mdostsa!');
    writeln;
    writeln;
    write('  Melyiket vlasztja? '); modositx := readkey;
    case modositx of
      '1' : modosit1;
      '2' : modosit2;
      #27 : write('ESC');
      else
        begin
          textcolor(c2); write('1 - 2 vagy ESC(Kilps)'); textcolor(c1);
          delay(1500);
          modosit;
        end;
    end;
  end;

procedure kereses;
  var
     nyszam         : string[100];
     nyertex,sikerx : boolean;
     ujkerszamx     : char;
     k              : word;
  begin
    assign(adatok,'nyszamok.dat');
    reset(adatok);
    repeat
      seek(adatok,0);
      nyertex := false;
      sikerx := false;
      alapkepernyo;
      writeln('  Krem a szmot(nyertesszmot) amit megkeressek: ');
      writeln;
      writeln;
      write('                    '); textcolor(c2); readln(nyszam); textcolor(c1);
      writeln;
      writeln;
      for k := 1 to filesize(adatok) do
        begin
          read(adatok,adat);
          nyertex := nyszam = adat.szam;
          if nyertex = true then
            if kategoriax = adat.kategoria then
              if adat.torolvee = false then
                begin
                  seek(adatok,filepos(adatok) - 1);
                  adat.nyerte := true;
                  write(adatok,adat);
                  sikerx := true;
                  writeln('        A(z) ',adat.szam,' szmot megtalltam!');
                  writeln;
                  textcolor(c3); writeln('                    Gratullok, NYERT!'); textcolor(c1);
                end;
        end;
      if sikerx <> true then
        begin
          write('  A szm a(z) '); kategoriaki; writeln('-s kategriban nem tallhat!');
        end;
      writeln;
      writeln;
      write('  Kvn megadni j szmot ( ');
        textcolor(c2); write('ENTER'); textcolor(c1); write('-Igen / ');
        textcolor(c2); write('Brmely ms lets'); textcolor(c1); write('-Nem ) ? ');
      ujkerszamx := readkey;
    until ujkerszamx <> #13;
    close(adatok);
  end;

procedure listaz;
  var
     i,j : word;
  begin
    j := 0;
    assign(adatok,'nyszamok.dat');
    reset(adatok);
    alapkepernyo;
    writeln('  #                      SZM');
    writeln(' ===============================================');
    writeln;
    for i := 1 to filesize(adatok) do
      begin
        read(adatok,adat);
        if adat.kategoria = kategoriax then
          if adat.torolvee = false then
            begin
              inc(j);
              textcolor(c2);
              write('  ',j,'   ');
              if adat.nyerte = true then
                begin
                  textcolor(c3); write('NYERT'); textcolor(c2);
                end
                else write('     ');
              writeln('          ',adat.szam); textcolor(c1);
            end;
      end;
    close(adatok);
    readkey;
  end;

procedure ujszam;
  var
     ujszamx : char;
  begin
    assign(adatok,'nyszamok.dat');
    reset(adatok);
    seek(adatok,filesize(adatok));
    repeat
      alapkepernyo;
      write('  Krem a(z) '); kategoriaki; writeln('-s kategrihoz tartoz j szmot: ');
      writeln;
      writeln;
      write('                    ');  textcolor(c2); readln(adat.szam); textcolor(c1);
      adat.kategoria := kategoriax;
      adat.torolvee := false;
      adat.nyerte := false;
      write(adatok,adat);
      writeln;
      writeln;
      writeln('                  Az j szm elmentve...');
      writeln;
      writeln;
      write('  Kvn megadni j szmot ( ');
        textcolor(c2); write('ENTER'); textcolor(c1); write('-Igen / ');
        textcolor(c2); write('Brmely ms lets'); textcolor(c1); write('-Nem ) ? ');
      ujszamx := readkey;
    until ujszamx <> #13;
    close(adatok);
  end;

procedure lehetosegek;
  var
     lehetosegx : char;
  begin
    alapkepernyo;
    write('  '); textcolor(c2); write('1'); textcolor(c1);
      write(' - Keress a(z) '); kategoriaki; writeln('-s kategrin bell');
    writeln;
    write('    '); textcolor(c2); write('2'); textcolor(c1); writeln(' - Az j szmok bevitele');
    writeln;
    write('      '); textcolor(c2); write('3'); textcolor(c1); writeln(' - A kategrin belli szmok listja');
    writeln;
    write('        '); textcolor(c2); write('4'); textcolor(c1); writeln(' - Karbantarts (Trls/Mdosts)');
    writeln;
    writeln;
    write('  Melyiket vlasztja? '); lehetosegx := readkey;
    case lehetosegx of
      '1' : kereses;
      '2' : ujszam;
      '3' : listaz;
      '4' : modosit;
      #27 : write('ESC');
      else
        begin
          textcolor(c2); write('1 - 4 vagy ESC(Kilps)'); textcolor(c1);
          delay(1500);
          lehetosegek;
        end;
    end;
  end;

begin
  textbackground(c4);
  textcolor(c1);
  clrscr;
  vanfile;
  kategoria;
  while kategoriax <> #27 do
    begin
      lehetosegek;
      kategoria;
    end;
  alapkepernyo;
  delay(1000);
  textbackground(black);
  textcolor(lightgray);
end.
