<?php

/**
* Felhaszn�l�i adminisztr�ci�t kezel� Oszt�lyok
* 
* Bel�ptet�s, K�vet�s, Regisztr�ci�
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

/**
* Saj�t hiba (kiv�tel) kezel� Oszt�ly (Adminisztr�ci�s hib�khoz)
* 
* Tipikus adminisztr�ci�s hiba p�ld�ul a bel�p�s megtagad�sa
* hib�s n�v jelsz� p�r eset�n.
*/
class AuthException extends MyException {}

/**
* Alapvet� felhaszn�l�i adatokat kezel� Oszt�ly 
*/
class User
{
    /**
    * Az �j felhaszn�l�k egyb�l akt�van j�jjenek e l�tre
    * 
    * Amikor akt�v a felhaszn�l� be tud jelentkezni
    * teljes funkcionalit�s mellet.
    * 
    * 0 nem akt�van j�n l�tre
    * 1 akt�van j�n l�tre
    * 
    * @var integer $when_insert_is_active
    */
    protected static $when_insert_is_active = 1;
    
    /**
    * Azt adja meg mely adat-elemeket
    * t�ltse be a felhaszn�l� objektum-
    * p�ld�ny�ba
    * 
    * Ezek az elemek egy SQL SELECT tagjai.
    * Azon oszlopok nevei amikben a k�v�nt
    * adatok szerepelnek.
    * 
    * <code>
    * $user_data_elements = "id, name, email, reg_date";
    * 
    * SELECT $user_data_elements FROM ... 
    * </code>
    * 
    * @var string $user_data_elements
    */
    protected $user_data_elements = "id, name, email, reg_date";
    
    /**
    * Egyedi felhaszn�l�i azonos�t�
    * 
    * Minden egyes felhaszn�l� megkapja az
    * adatb�zist�l (auto inc) ezt az azonos�t�t
    * mikor besz�r�sra ker�l az adatb�zisba �s
    * innent�l kezdve ez permanensen meg is
    * marad neki azonos�t�k�nt.
    * 
    * @var integer $id
    */
    public $id;
    
    /**
    * Egyedi felhaszn�l�i n�v
    * 
    * R�vid becen�v (az ami mindenki
    * sz�m�ra l�tsz�dik)
    * 
    * @var string $name
    */
    public $name;
    
    /**
    * A felhaszn�l� email c�me
    * 
    * A rendszer �s a t�bbi felhaszn�l� is
    * erre tudja k�ldeni az �zeneteket.
    * 
    * @var string $email
    */
    public $email;
    
    /**
    * A regisztr�ci�j�nak id�pontja
    * 
    * @var string $reg_date alakja: ("Y-m-d H:i:s")
    */
    public $reg_date;
    
    /**
    * A felhaszn�l� jelszava
    * 
    * A jelsz� eredetij�nek id�glenes
    * t�rol�s�ra kap �rt�ket a regisztr�ci�
    * idej�re. Ezut�n m�r nincs szerepe.
    * (Az azonos�t�s sor�n sem ker�l t�bb� haszn�latba.
    * A jelsz�nak am�gy csup�n az MD5 hash-�t t�rolja a
    * rendszer.)
    * 
    * @var string $email
    */
    protected $pwd;
    
    /**
    * Constructor
    * 
    * Bel�pteti a felhaszn�l�t az id-je alapj�n (ha
    * az id meg van adva): k�sz�t egy user p�ld�nyt
    * �s fel is t�lti a felhaszn�l� adataival. Ha 
    * nincs megadva az id h�v�skor egy �res p�ld�nnyal
    * t�r vissza.
    * 
    * @param integer $id a felhaszn�l�i azonos�t�
    *                    (alap�rtelmezetten false - nincs azonos�t�
    *                     �res p�ld�ny fog l�trej�nni)
    * @return null �rt�k n�lk�l t�r vissza (ha id n�lk�l h�vtuk
    *              meg a konstruktort) ha h�v�skor megadtuk az id-t
    *              NEM t�r vissza hanem l�trehozza �s felt�lti az
    *              objektumot
    * @throws ha id meg volt adva de ehhez m�gsem tartozik felhaszn�l�
    *         (SecException) hib�t dob (hack vesz�ly)
    */
    public function __construct($id = false)
    {
        if (!$id) {
            return;
        }
        $stmt = $GLOBALS['dbh']->prepare("SELECT ".$this->user_data_elements."
                                          FROM administration
                                          WHERE id = ?");
        $stmt->execute(array($id));
        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user_data) {
        	foreach ($user_data as $data => $value) {
                $this->$data = $value;
            }
        } else {
        	throw new SecException($GLOBALS['st']['error_in_header'], 0, $id);
        }
    }
    
    /**
    * Bel�pteti a felhaszn�l�t (n�v �s jelsz� p�r alapj�n),
    * a user p�ld�nyt felt�lti a felhaszn�l� adataival
    * 
    * @param string $name ellen�rizend� felhaszn�l�i n�v
    * @param string $pwd ellen�rizend� jelsz� hash (md5)
    * @throws ha fennakad az ellen�rz�sen (AuthException) kiv�telt dob
    */
    public function login($name, $pwd)
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT ".$this->user_data_elements." 
                                          FROM administration 
                                          WHERE name = ? 
                                            AND pwd = ?");
        $stmt->execute(array($name, md5($pwd)));
        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user_data) {
        	foreach ($user_data as $data => $value) {
                $this->$data = $value;
            }
        } else {
        	throw new AuthException($GLOBALS['st']['login_accesdenied'], 0, $name.$pwd);
        }
    }
    
    /**
    * Megvizsg�lja, hogy az Objektump�ld�nyban
    * szerepl� n�ven van e regisztr�lva m�r
    * egy felhaszn�l�.
    * 
    * @throws ha van m�r ilyen nev� felhaszn�l�
    *         (MyException) hib�t dob
    */
    public function isExist()
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT name FROM administration WHERE name = ?");
        $stmt->execute(array($this->name));
        $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($user_data) {
            throw new MyException($GLOBALS['st']['error_user_exist']);
        }
    }
    
    /**
    * Besz�rja az adatb�zisba az �j felhaszn�l�
    * Objektump�ld�ny�ban szerepl� f�adatait.
    */
    public function insert()
    {
        $user_data = array($this->name,
                           md5($this->pwd),
                           self::$when_insert_is_active,
                           date("Y-m-d H:i:s"),
                           $this->email);
        $stmt = $GLOBALS['dbh']->prepare("INSERT INTO administration
                                            (id, name, pwd, is_active, reg_date, email)
                                          VALUES (NULL, ?, ?, ?, ?, ?)");
        $stmt->execute($user_data);
    }
    
    /**
    * T�rli az adatb�zisb�l az Objektump�ld�ny�ban
    * szerepl� felhaszn�l�t.
    */
    public function delete()
    {
        $stmt = $GLOBALS['dbh']->prepare("DELETE FROM administration WHERE id = ?");
        $stmt->execute(array($this->id));
    }

}

/**
* Regisztr�ci� sor�n megadott �j felhaszn�l�i
* adatok ellen�rz�s�t kezel� Oszt�ly
*/
class CheckNewUser extends User
{
    /**
    * Constructor
    * 
    * Bet�lti a param�terben megadott �j felhaszn�l�hoz
    * tartoz� adatokat ha �tesnek az el�sz�r�se.
    * 
    * El�sz�r�s:
    * 1. ellen�rz�sre ker�l hogy minden param�ter meg 
    *    lett e adva
    * 2. ellen�rzi hogy a jelsz� �s az ellen�rz� jelsz�
    *    egyezik e
    * 
    * @param string $name felhaszn�l�i n�v
    * @param string $pwd jelsz�
    * @param string $confirm_pwd ellen�rz� jelsz�
    * @param string $email felhaszn�l� email c�me
    * @throws ha az adatok fennakadnak az el�sz�r�sen 
    *         (MyException) kiv�telt dob
    */
    public function __construct($name, $pwd, $confirm_pwd, $email)
    {      
        if (!$name || !$pwd || !$confirm_pwd || !$email) {
            throw new MyException($GLOBALS['st']['texterror_missing']);
        }
        if ($pwd != $confirm_pwd) {
            throw new MyException($GLOBALS['st']['texterror_confirmpwd']);
        }
        $this->name      = $name;
        $this->pwd       = $pwd;
        $this->email     = $email;
    }
    
    /**
    * Ellen�rzi a felhaszn�l�hoz tartoz�
    * objektump�ld�nyban szerpl� adatokat
    * (ha fennakad az ellen�rz�sen Kiv�tel
    *  bubor�k indul a bels� f�ggv�nyekb�l)
    */
    public function valid()
    {
        CheckData::isAlphanumeric($this->name, 10, 2);
        CheckData::isAlphanumeric($this->pwd, 12, 4);
        CheckData::isEmail($this->email);
    }

}

/**
* Felhaszn�l�i Cookie-kat kezel� Oszt�ly
*/
class Cookie
{
    /**
    * Az �j Cookie-k neve
    *  
    * @var string $cookie_name
    */
    public static $cookie_name = "UID";
    
    /**
    * Az �j Cookie-k verzi�ja
    *  
    * @var string $akt_version
    */
    protected static $akt_version = "1";
    
    /**
    * Az �j Cookie-k lej�rati ideje
    * m�sodpercben megadva
    * 
    * Egy h�nap: 2419200 (60*60*24*7*4)
    *  
    * @var integer $expiration
    */
    protected static $expiration = 2419200;
    
    /**
    * Az �j Cookie-k ezen id� lej�rta
    * ut�n meg�j�tj�k a lej�rati idej�ket,
    * teh�t �j Cookie k�sz�l ezen id�
    * lej�rta �s a lej�rati id�($expiration)
    * k�z�tti id�ben
    * 
    * F�l h�nap: 2419200/2
    *  
    * @var integer $update_timer
    */
    protected static $update_timer = 1209600;
    
    /**
    * A Cookie-k bels� form�z�s��rt felel�s
    * elv�laszt� karakter.
    *  
    * @var string $glue
    */
    protected static $glue = "|";
    
    /**
    * Mcrypt be�ll�t� tag, az �j Cookie-k
    * titkos�t�s�nak tipusa
    * 
    * @var string $cypher
    */
    protected static $cypher = "blowfish";
    
    /**
    * Mcrypt be�ll�t� tag, az �j Cookie-k
    * titkos�t�s�nak m�dozata
    * 
    * @var string $mode
    */
    protected static $mode = "cfb";
    
    /**
    * Mcrypt be�ll�t� tag, az �j Cookie-k
    * titkos�t�s�nak kulcsa (�lland�k�nt az 
    * �rt�ke a config file-ben megadva)
    * 
    * @var string $key
    */
    protected static $key = MCRYPT_KEY0;
    
    /**
    * Mcrypt tag, az �j Cookie
    * titkos�t�s le�r�j�t t�rolja
    * (illetve hiba eset�n false)
    * 
    * @var resource $td
    */
    protected $td;
    
    /**
    * Felhaszn�l�i azonos�t�
    * 
    * @see User::$id;
    * @var integer $user_id
    */
    public $user_id;
    
    /**
    * Az �j Cookie k�sz�l�s�nek id�pontja,
    * �rt�k�t egy time() f�ggv�nyt�l kapja
    * 
    * @var integer $created
    */
    public $created;
    
    /**
    * A Cookie verzi�ja
    *  
    * @var string $version
    */
    public $version;
    
    
    /**
    * Constructor
    * 
    * Be�ll�tja a mcrypt le�r�j�t td-t majd ha meg van
    * adva a user_id param�ter (teh�t m�r van egy azonos�tott
    * felhaszn�l�)  berakja az azonos�t�j�t az �j
    * cookie p�ld�nyba ha nincs id megadva megpr�b�lja azt
    * a felhaszn�l� COOKIE-j�b�l kiolvasni ha ez nem siker�l
    * be�ll�tja a $user_id tulajdons�g�t false-ra
    * 
    * @param integer $user_id felhaszn�l� azonos�t�ja
    */
    public function __construct($user_id = false)
    {
        $this->td = mcrypt_module_open(self::$cypher, '', self::$mode, '');
        if ($user_id) {
            $this->user_id = $user_id;
        } else {
            if (array_key_exists(self::$cookie_name, $_COOKIE)) {
                $buffer = $this->unpackage($_COOKIE[self::$cookie_name]);
            } else {
                $this->user_id = false;
            }
        }
    }
    
    /**
    * A felhaszn�l�nak egy cookie-t �ll�t be
    */
    public function set()
    {
        $cookie = $this->package();
        setcookie(self::$cookie_name, $cookie, time()+self::$expiration);
    }
    
    /**
    * Ellen�rzi hogy �rv�nyes �s megfelel� e a felhaszn�l�i
    * Cookie-b�l vett adatok, amennyiben a cookie nem j�rt
    * m�g le (expiration) de a meg�j�t�si hat�rid�n 
    * (update_timer) m�r t�lhaladt �j cookie-t k�sz�t
    * 
    * @throws ha a cookie nem megfelel� form�tum� vagy
    *         ha a verzi� nem megfelel� vagy
    *         ha lej�rt a cookie (AuthException) kiv�telt dob
    */    
    public function valid()
    {
        if (!$this->version || !$this->created || !ctype_digit($this->user_id)) {
            throw new AuthException($GLOBALS['st']['error_in_cookie_maleformed'], 0, 
                                      $this->version.$this->created.$this->user_id);
        }
        if ($this->version != self::$akt_version) {
            throw new AuthException($GLOBALS['st']['error_in_cookie_vermismatch'], 0,
                                      $this->version.$this->created.$this->user_id);        
        }
        if (time() - $this->created > self::$expiration) {
            throw new AuthException($GLOBALS['st']['error_in_cookie_expired'], 0,
                                      $this->version.$this->created.$this->user_id);
        } elseif (time() - $this->created > self::$update_timer) {
            $this->set();
        }
    }
    
    /**
    * K�sz�t egy 0 lej�rati idej� �res cookie-t
    */
    public function close()
    {
        setcookie(self::$cookie_name, '', 0);
    }
    
    /**
    * K�sz�t egy form�zott adattartalmat:
    * verzi�, akt id�, user_id majd megh�vja
    * r� a titkos�t� f�ggv�nyt �s a k�dolt 
    * tartalommal visszat�r (ez fogja a 
    * cookie adattartalm�t k�pezni)
    * 
    * @return string titkos�tott cookie
    *         sz�m�ra form�zott adattartalom  
    */
    protected function package()
    {
        $parts = array(self::$akt_version, time(), $this->user_id);
        $cookie = implode(self::$glue, $parts);
        $buffer = $this->encrypt($cookie);
        $buffer = urlencode($buffer);
        return $buffer;
    }
    
    /**
    * Felt�lti a cookie p�ld�nyt a felhaszn�l�i
    * (cookie-b�l sz�rmaz�) dekod�lt adatokkal
    * 
    * @param string $cookie felhaszn�l�t�l beolvasott cookie adattartalma
    */
    protected function unpackage($cookie)
    {
        $cookie = urldecode($cookie);
        $buffer = $this->decrypt($cookie);
        list($this->version, $this->created, $this->user_id) = explode(self::$glue, $buffer);
    }
    
    /**
    * K�dol� met�dus
    * 
    * @param string $text k�doland� sz�veg
    * @return string k�dolt sz�veg (az elej�re f�zve az iv vektort)
    */
    protected function encrypt($text)
    {
        $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($this->td), MCRYPT_RAND);
        mcrypt_generic_init($this->td, self::$key, $iv);
        $encrypted_text = mcrypt_generic($this->td, $text);
        mcrypt_generic_deinit($this->td);
        return $iv.$encrypted_text;
    }
    
    /**
    * Dek�dol� met�dus
    * 
    * @param string $encrypted_text k�dolt sz�veg
    * @return string dek�dolt sz�veg
    */
    protected function decrypt($encrypted_text)
    {
        $iv_size = mcrypt_get_iv_size(self::$cypher, self::$mode);
        $iv = substr($encrypted_text, 0, $iv_size);
        $encrypted_text = substr($encrypted_text, $iv_size);
        mcrypt_generic_init($this->td, self::$key, $iv);
        $text = mdecrypt_generic($this->td, $encrypted_text);
        mcrypt_generic_deinit($this->td);
        return $text;
    }
    
}
  
?>