<?php

/**
* Alapvető Osztályok
* 
* Hiba (Kivétel) kezelés
* Tartalomkezelő
* Felhasználótól származó adatok ellenőrzése
* Szerver karbantartási kezelők
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

/**
* Hiba (Kivétel) kezelés
*/
class MyException extends Exception
{
    /**
    * Minden létrejövő és (save metódussal) mentett 
    * hiba objektumot tartalmazó tömb
    * 
    * @var array $exceptions;
    */
    public static $exceptions = array();
    
    /**
    * Ha van olyan változó ami miatt
    * a hiba keletkezett az ide kerül átadásra
    * 
    * @var mixed $problem_var
    */
    public $problem_var;
    
    /**
    * A hiba elmentése az $exceptions statikus
    * tömbe és a log file-ba
    * 
    * kiegészítő adatokkal vértezi fel a hibát:
    * 1. id  'Y-m-d H:i:s'
    * 2. ip cím
    * 
    * !!! (1) Biztonságossabban kezelni a logfájlbairandó adatokat!
    * 
    * @param object $exception ellenőrizendő kivétel
    * @param int $mode (használaton kívül)
    */
    public static function save($exception, $mode = 0)
    {
        $log_data  = array("time" => date('Y-m-d H:i:s'),
                           "ip"   => $_SERVER['REMOTE_ADDR'],
                           "exception" => $exception);
        if (isset($exception->problem_var)) {
            $log_data['problem_var'] = '"'.$exception->problem_var.'"';
        }
        // mentés a statikus tömbe
        self::$exceptions[] = $log_data;
        // mentés log file-ba
        $log = implode(" | ", $log_data);
        error_log($log.chr(13).chr(10), 3, 'dat/log/error.log');
        // mentés adatbázisba (a figyelő tokenhez)
        if (isset($GLOBALS['wu'])) {
        	$GLOBALS['wu']->setErrorReport('Hiba történt: '.$log.' ');
        }
    }
    
    /**
    * A hiba kiiratása (print) html formátumban
    */
    public static function getExceptions()
    {
        if (self::$exceptions) {
            $html  = "\n    <div id=\"user_alert\">\n";
            $html .= "      <h4><span>".$GLOBALS['st']['error']."</span></h4>\n";
            foreach (self::$exceptions as $e) {
                $html .= "      <p><span>".$e['exception']->getMessage()."</span></p>\n";
            }
            $html .= "    </div>\n\n";
            print $html;
        }
    }
    
    /**
    * Constructor
    * 
    * Saját hibakezelő kiegészítve egy opcionális
    * hibás változót befogadó paraméterrel
    * 
    * @see parent::__construct()
    * 
    * @param string $message hibajelentés szövege
    * @param integer $code hibakód (see parent::__construct())
    * @param mixed $problem_var esetleges hibás változó
    */
    public function __construct($message = 'unknown error', $code = 0, $problem_var = false)
    {
        if ($problem_var) {
            $this->problem_var = $problem_var;
        }
        parent::__construct($message, $code);
    }
}

/**
* Biztons�gi hiba (kiv�tel)-t kezel� aloszt�ly
*/
class SecException extends MyException {}

/**
* Felhaszn�l�t�l sz�rmaz� adatok ellen�rz�se
*/
class CheckData
{
    /**
    * Alphanumerikuss�g �s sz�veghossz ellen�rz�se
    * 
    * @param string $data ellen�rizend� adat
    * @param integer $max_length a maxim�lis sz�veghossz (ha 0 nincs vizsg�lat) 
    *                            nem k�telez� (alap�rt�k 0)
    * @param integer $min_length a minim�lis sz�veghossz (ha 0 nincs vizsg�lat) 
    *                            nem k�telez� (alap�rt�k 0)
    * @throws ha fennakad az ellen�rz�sen (MyException) kiv�telt dob
    */
    public static function isAlphanumeric($data, $max_length = 0, $min_length = 0)
    {
        if (($max_length && (strlen($data) > $max_length)) || 
            ($min_length && (strlen($data) < $min_length))) {
            throw new MyException($GLOBALS['st']['texterror_length']);
        }
        if (!preg_match('/^[a-z0-9]+$/iD', $data)) {        
            throw new MyException($GLOBALS['st']['texterror_format']);        
        }
    }

    /**
    * Email alaki form�tum�nak ellen�rz�se
    * 
    * @param string $email ellen�rizend� email c�m
    * @param integer $max_length a maxim�lis hossza az email c�mnek 
    *                            (alap�rt�k 80 karakter)
    * @throws ha fennakad az ellen�rz�sen (MyException) kiv�telt dob
    */
    public static function isEmail($email, $max_length = 80)
    {
        if (strlen($email) > $max_length) {
            throw new MyException($GLOBALS['st']['texterror_length']);
        }
        if (!preg_match('/^[a-z0-9_\.-]+@[a-z0-9_\.-]+\.[a-z0-9]+$/iD', $email)) {
            throw new MyException($GLOBALS['st']['texterror_email']);
        }
    }
}

/**
* Szerver karbantartási kezelők
*/
class Server
{
    /**
    * linux uptime parancs eredményei
    * 
    * @var string $uptime
    */
    public $uptime;
    
    /**
     * uptime load adatok
     * 
     * @var array $uptime_load
     */
    public $uptime_load;
    
    /**
     * uptime napok száma (0-now, 1-prev, 2-record)
     * 
     * @var array $uptime_up
     */
    public $uptime_up;
    
    /**
     * CPU hőmérséklet értéke
     *
     * @var string $temperature
     */
    public $temperature = 'temperature: ?';
    
    /**
     * grafikon kép fájlok helye
     * 
     * @var array $graph_path
     */
    public $graph_path = array();
    
    /**
     * xml uptime szerkezet
     * 
     * @var string $xml_uptime
     */
    private $_xml_uptime = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
                            <server>
                              <up>
	                            <record>0</record>
	                            <prev>0</prev>
	                            <now>0</now>
                              </up>
                            </server>';
    
    /**
    * Constructor
    * 
    * Alapvető információk betőltése a Szerverről
    */
    public function __construct()
    {
        $this->setUptime();
        $this->_uptimeXML();
    }
    
    /**
    * Linux uptime parancs eredményeit tőlti be
    * és menti el az adatbázisba (és beállítja az
    * aktuális img_id értékét ami a képek 
    * megjelenítéséhez kell)
    * 
    * Csak Unix like működik egyébként kivételt dob
    * uptime parancs
    * eredeti kimenet: 17:40:46 up 156 days, 7:31, 1 user, load average: 0.15, 0.30, 0.40
    * átalakított kimenet:
    * 0. 17:40:46
    * 1. 156
    * 2. 7:31
    * 3. 1
    * 4. 0.15
    * 5. 0.30
    * 6. 0.40
    * 
    * @throws MyException ha nem lehetett az uptime parancsot végrehajtani
    */
    public function setUptime()
    {
        if ($uptime = @exec('uptime')) {
            $this->uptime = trim($uptime);
            if ($this->temperature = @exec('cat /proc/acpi/thermal_zone/THM0/temperature')) {
                $this->uptime .= ' '.trim($this->temperature);
            }
            $buff = explode('load average: ', $uptime);
            $this->uptime_load = explode(',', $buff[1]);
            $buff = explode('up ', $buff[0]);
            $buff = explode(',', $buff[1]);
            $buff = explode(' ', $buff[0]);
            if (ctype_digit($buff[0]) && ($buff[1] == 'day' || $buff[1] == 'days')) {
            	$this->uptime_up[0] = $buff[0];
            } else {
            	$this->uptime_up[0] = 0;
            }
        } else {
        	throw new MyException('Ez a szolgáltatás UNIX like rendszereken működik (windows alatt nem)!');
        }
    }
    
    /**
     * Azonosítja az Átjárókat
     *
     */
    public static function getGate()
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT * FROM gate");
        $stmt->execute();
        $gate = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_UNIQUE);
        if ($gate) {
            echo "<table>";
        	foreach ($gate as $key => $value) {
                print "<tr><td><a href=\"".$key."\"><img src=\"./modules/Yhuann/misc/alev".$value['access_level'].".png\" alt=\"átjáró\" /></a></td><td class=\"alev".$value['access_level']."\"><a href=\"".$value['link']."\">".$key."</a></td><td class=\"comment\">".$value['comment']."</td></tr>";
            }
            echo "</table>";
        } else {
        	echo "<p>Sajnálom, nincs egyetlen elérhető Átjáró sem!</p>";
        }
    }
    
    /**
    * Grafikon kép (png) készítése
    * 
    * requirements: PEAR Image_Graph
    */
    public function makeUptimeGraphs()
    {
        error_reporting(E_ALL); // PEAR php4 compatibility bug
        require_once 'Image/Graph.php';

        // up
        $graph =& Image_Graph::factory('graph', array(200, 200));
        $graph->setBackgroundColor('#000000');
        $plotarea =& $graph->addNew('plotarea');
        $dataset =& Image_Graph::factory('dataset');
        $dataset->addPoint('now', $this->uptime_up[0], 'L');
        $dataset->addPoint('prev', $this->uptime_up[1], 'A');
        $dataset->addPoint('record', $this->uptime_up[2], 'A');
        $plot =& $plotarea->addNew('bar', $dataset);
        $plot->setLineColor('#000000');
        $plot->setBackgroundColor('#000000');
        $fill =& Image_Graph::factory('Image_Graph_Fill_Array');
        $fill->addColor('#666666', 'A');
        $fill->addColor('#FF3333', 'L');
        $plot->setFillStyle($fill);
        $yaxis =& $plotarea->getAxis(IMAGE_GRAPH_AXIS_Y);
        //$yaxis->setTitle('Server Up (days)', 'vertical');
        $yaxis->setFontColor('#FFF9999');
        $xaxis =& $plotarea->getAxis(IMAGE_GRAPH_AXIS_X);
        $xaxis->setTitle('Server Up - '.$this->uptime_up[0].'/'.$this->uptime_up[1].'/'.$this->uptime_up[2].' days');
        $xaxis->setFontColor('#FFF9999');
        
        exec('rm misc/server_up_*');
        $time = time();
        $this->graph_path[] = 'misc/server_up_'.$time.'.png';
        $graph->done(array('filename' => $this->graph_path[0]));
        
        // load
        $graph =& Image_Graph::factory('graph', array(200, 200));
        $graph->setBackgroundColor('#000000');
        $plotarea =& $graph->addNew('plotarea');
        $dataset =& Image_Graph::factory('dataset');
        $dataset->addPoint('-1m', $this->uptime_load[0]*100, 'L');
        $dataset->addPoint('-5m', $this->uptime_load[1]*100, 'A');
        $dataset->addPoint('-15m', $this->uptime_load[2]*100, 'A');
        $plot =& $plotarea->addNew('bar', $dataset);
        $plot->setLineColor('#000000');
        $plot->setBackgroundColor('#000000');
        $fill =& Image_Graph::factory('Image_Graph_Fill_Array');
        $fill->addColor('#666666', 'A');
        $fill->addColor('#FF3333', 'L');
        $plot->setFillStyle($fill);
        $yaxis =& $plotarea->getAxis(IMAGE_GRAPH_AXIS_Y);
        //$yaxis->setTitle('Server Load', 'vertical');
        $yaxis->setFontColor('#FFF9999');
        $xaxis =& $plotarea->getAxis(IMAGE_GRAPH_AXIS_X);
        $xaxis->setTitle('Server Load');
        $xaxis->setFontColor('#FFF9999');
        
        exec('rm misc/server_load_*');
        $time = time();
        $this->graph_path[] .= 'misc/server_load_'.$time.'.png';
        $graph->done(array('filename' => $this->graph_path[1]));
    }
    
    private function _uptimeXML()
    {
        	if ($file = fopen('dat/server.xml','a+')) {
        	    $content = stream_get_contents($file);
        	    if (empty($content)) {
        	     	fwrite($file, $this->_xml_uptime);
        	    }
                fclose($file);
            } else {
        	    throw new MyException('Nem tudom elérni a dat/server.xml fájlt!');
            }
        $xml = simplexml_load_file('dat/server.xml');
        if ($xml->up->record < $this->uptime_up[0]) {
            $xml->up->record = $this->uptime_up[0];
        }
        if ($xml->up->now > $this->uptime_up[0]) {
            $xml->up->prev = $xml->up->now;
        }
        $xml->up->now = $this->uptime_up[0];
        $xml->asXML('dat/server.xml');
        $this->uptime_up[1] = $xml->up->prev;
        $this->uptime_up[2] = $xml->up->record;
    }
        
}

?>
