<?php

/**
* DnD - Dungeons and Dragons eszk�z�ket kezel� Oszt�ly
* 
* @package DnD
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page (D&D (c) Wizards of the Coast, Inc.)
*/

/**
* V�d�s�rk�nyokat kezel� Oszt�ly
*/
class DnD_Defdragon
{
    /**
    * A Vend�gek sz�m�ra fentartott V�d�s�rk�ny
    * 
    * Ez a S�rk�ny ak�rh�ny felhaszn�l�hoz tartozhat,
    * ellenben a t�bbi V�d�s�rk�nnyal amik egyedien
    * csakis egy felhaszn�l�hoz tartozhatnak. �gy a
    * Vend�gek sz�m�ra ezt aj�nlja regisztr�l�sra.
    * Megjegyz�s: illetve ha elfogytak az egyedi
    * S�rk�nyok m�r csak ez a S�rk�ny marad az �j
    * regisztr�l�k sz�m�ra.
    * 
    * @var string $defdragon_reserved_guest
    */
    public static $reserved_guest = 'defdragon_bigdefender';
    
    /**
    * A l�tez� V�d�s�rk�nyok
    * 
    * @var array $defdragons
    */  
    public static $defdragons = array('defdragon_bigdefender',
                                      'defdragon_black',
                                      'defdragon_blue',
                                      'defdragon_brass',
                                      'defdragon_bronze',
                                      'defdragon_brown',
                                      'defdragon_copper',
                                      'defdragon_deep',
                                      'defdragon_fang',
                                      'defdragon_gold',
                                      'defdragon_green',
                                      'defdragon_red',
                                      'defdragon_shadow',
                                      'defdragon_silver',
                                      'defdragon_white');
    
    /**
    * A m�r birtokolt (foglalt) V�d�s�rk�nyok lek�rdez�se
    * egy t�mbe, a vend�gek sz�m�ra fentartott v�d�s�rk�ny
    * kiv�tel�vel
    * 
    * @return array foglalt V�d�s�rk�nyok [kulcs: a gazd�ja neve]
    */
    public static function getUsedDefdragons()
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT name, defdragon
                                          FROM administration
                                          WHERE NOT defdragon = ?");
        $stmt->execute(array(self::$reserved_guest));
        $used_defdragons = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_COLUMN|PDO::FETCH_UNIQUE);
        return $used_defdragons;
    }
    
    /**
    * Defdragon v�ltoz� el�rhet�s�g�nek �s biztons�gi kock�zat�nak
    * ellen�rz�se
    * 
    * @param string $defdragon felhaszn�l�t�l sz�rmaz� defdragon n�v
    * @throws ha fennakad az ellen�rz�sen Kiv�telt dob
    *         MyException tipust ha m�r haszn�lt a v�d�s�rk�ny
    *         SecException tipust ha nem l�tezik ilyen v�d�s�rk�ny (hack vesz�ly)
    */
    public static function isDefdragon($defdragon)
    {
        if (!in_array($defdragon, self::$defdragons)) {
            throw new SecException($GLOBALS['st']['error_in_header'], 0, $defdragon);
        }
        if (in_array($defdragon, self::getUsedDefdragons())) {
            throw new MyException($GLOBALS['st']['error_user_exist']);
        }
    }
    
}

/**
* DnD-s tulajdons�gokkal felv�rtezett Felhaszn�l�i(User)
* adatokat kezel� Oszt�ly
*/
class DnD_User extends User
{
    /**
    * Azt adja meg mely adat-elemeket
    * t�ltse be a felhaszn�l� objektum-
    * p�ld�ny�ba
    * 
    * @see parent::$user_data_elements
    * @var string $user_data_elements
    */
    protected $user_data_elements = "id, name, defdragon, email, reg_date";
    
    /**
    * A felhaszn�l�hoz tartoz� V�d�s�rk�ny
    * 
    * @var string $defdragon;
    */ 
    public $defdragon;
    
    /**
    * Besz�rja az adatb�zisba az �j felhaszn�l�
    * Objektump�ld�ny�ban szerepl� f�adatait.
    */
    public function insert()
    {
        $user_data = array($this->name,
                           md5($this->pwd),
                           self::$when_insert_is_active,
                           date("Y-m-d H:i:s"),
                           $this->defdragon,
                           $this->email);
        $stmt = $GLOBALS['dbh']->prepare("INSERT INTO administration
                                            (id, name, pwd, is_active, reg_date, defdragon, email)
                                          VALUES (NULL, ?, ?, ?, ?, ?, ?)");
        $stmt->execute($user_data);
    }
    
}

/**
* Regisztr�ci� sor�n megadott �j felhaszn�l�i
* adatok ellen�rz�s�t kezel� Oszt�ly
*/
class DnD_CheckNewUser extends DnD_User
{
    /**
    * Constructor
    * 
    * @see CheckNewUser::__construct() 
    * @param string $name felhaszn�l�i n�v
    * @param string $pwd jelsz�
    * @param string $confirm_pwd ellen�rz� jelsz�
    * @param string $email felhaszn�l� email c�me
    * @param string $defdragon a felhaszn�l� v�d�s�rk�nya
    * @throws ha az adatok fennakadnak az el�sz�r�sen 
    *         (MyException) kiv�telt dob
    */
    public function __construct($name, $pwd, $confirm_pwd, $email, $defdragon)
    {      
        if (!$name || !$pwd || !$confirm_pwd || !$email || !$defdragon) {
            throw new MyException($GLOBALS['st']['texterror_missing']);
        }
        if ($pwd != $confirm_pwd) {
            throw new MyException($GLOBALS['st']['texterror_confirmpwd']);
        }
        $this->name      = $name;
        $this->pwd       = $pwd;
        $this->email     = $email;
        $this->defdragon = $defdragon;
    }
    
    /**
    * Ellen�rzi a felhaszn�l�hoz tartoz�
    * objektump�ld�nyban szerpl� adatokat
    * (ha fennakad az ellen�rz�sen Kiv�tel
    *  bubor�k indul a bels� f�ggv�nyekb�l)
    */
    public function valid()
    {
        CheckData::isAlphanumeric($this->name, 10, 2);
        CheckData::isAlphanumeric($this->pwd, 12, 4);
        CheckData::isEmail($this->email);
        DnD_Defdragon::isDefdragon($this->defdragon);
    }
    
}

?>