<?php

/**
* Fórum kezelő
* 
* @package Forum
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2008 danworld page
*/

define("FORUM_MSGSPERPAGE_NORMAL", 50);
define("FORUM_RSS_MSGSNUM", 25);

/**
* Fórum objektum
*/
class Forum
{
    /**
    * fórumbejegyzések tárolója
    * 
    * @var array $_msg_data
    */
    private $_msg_data;
    
    /**
    * címkék tárolója
    * 
    * @var array $_labels
    */
    private $_labels;
    
    /**
    * összes aktív (type=1) üzenet száma
    * 
    * @var int $_msg_num
    */
    private $_msg_num;
    
    /**
     * visszavont üzenetek (id) tárolója
     *
     * @var array $_repeal_msgs_id
     */
    private $_repeal_msgs_id = array();
    
    /**
    * felhasználóhoz tartozó piszkozatok
    * száma (csak a getTools-ban kap
    * értéket)
    * 
    * @var int $_draft_num
    */
    private $_draft_num = 0;
    
    /**
    * alapértelmezett cimke
    * (ha nincs megadva semmi)
    * 
    * @var string $_default_label
    */
    private $_default_label = 'csevegés';
    
    /**
     * az oldalon egyszerre megjelenített
     * üzenetek száma
     * 
     * @var int $_msgs_perpage
     */
    private $_msgs_perpage = FORUM_MSGSPERPAGE_NORMAL;
    
    /**
    * Egy üzenet visszavonhatóságának maximális ideje
    * másodpercben def 18 perc (kliens oldalon 15 perc
    * után tűnik el a lehetőség a modosításra) 
    * 
    * @var int $_repealmsg_expire
    */
    private $_repealmsg_expire = 1080;
    
    /**
    * címkék maximális mérete a
    * címkefelhőben
    * 
    * @var int $_labels_max_size
    */
    private $_labels_max_size = 10;
    
    /**
     * A tervezett üzenetek dobozban
     * ennyi karakter után levágja az
     * üzenetet
     *
     * @var int $_draft_maxchar
     */
    private $_draft_maxchar = 130;
    
    /**
    * utolső adatbázisba töltött üzenet
    * AJAX szinkronizáláshoz
    * 
    * @var int $_last_msg_id
    */
    private $_last_msg_id;
    
    /**
    * új piszkozat azonosítója
    * 
    * AJAX szinkronizáláshoz
    * az insert metódusban last insert
    * értékét veszi fel
    * 
    * @var int $_last_draft_id
    */
    private $_last_draft_id;
    
    /**
    * Constructor
    * 
    */
    /*public function __construct()
    {
        
    }*/
    
    /**
    * beszúr egy új vagy (egy modosított) tervezett üzenetet
    * 
    * @param int $msg_id üzenet (klienstől jövő) id-je ha van
    * @param string $msg üzenet forrás szövege
    * @param int $user_id üzenet tulajdonosa (felhasználói azonosító)
    * @param string $labels cimkék (vesszővel elválasztva)
    * @param int $type tipus (0-törölt,1-aktív,2-piszkozat,3-módosításra visszavonva) def 1
    * @throws hiba az üzenet beszúrásakor
    */
    public function insert($msg_id, $msg, $user_id, $labels, $type = 1)
    {
        if ($msg_id != '') {
            // létező tervezett (type = 2 vagy 3) üzenet modosítása
            $stmt = $GLOBALS['dbh']->prepare('SELECT id as mid, msg, type
                                              FROM messages
                                              WHERE id = ? AND
                                                    owner = ? AND
                                                    type != ?');
            $stmt->execute(array($msg_id, $user_id, 1));
            $mid = $stmt->fetch(PDO::FETCH_ASSOC);
            if (empty($mid)) {
                throw new SecException("{'newmsgs':'','error':'<div class=\"msg_warning\">".$GLOBALS['st']['error_in_header']."</div>'}", 0, $msg_id.$user_id);
            }
            if ($mid['msg'] == $msg &&
                $type == 2 &&
                $mid['type'] == 2) {
                throw new MyException("{'newmsgs':''}");
            }
            if ($mid['type'] != 3) {
                $stmt = $GLOBALS['dbh']->prepare('UPDATE messages 
                                                  SET type = 0
                                                  WHERE id = ?');
                $stmt->execute(array($mid['mid']));
            }
        }
        // előszűrés, ellenőrzés
            // üres üzenetek kiszűrése
            if ($msg == '') {
                throw new MyException("{'newmsgs':'','error':'<div class=\"msg_alert\">Nem küldhetsz üres üzenetet! Miért is tennéd, nemigaz?</div>'}");
            }
            // véletlen duplikáció kiszűrése
            $stmt = $GLOBALS['dbh']->prepare('SELECT msg, date 
                                              FROM messages
                                              WHERE owner = ? AND
                                                    type = ?
                                              ORDER BY id DESC
                                              LIMIT 1');
            $stmt->execute(array($user_id, $type));
            $prev_msg = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($prev_msg['msg'] == $msg &&
                time() < (strtotime($prev_msg['date'])+15)) {
                throw new MyException("{'newmsgs':'','error':'<div class=\"msg_alert\">Duplikált üzenet! 15 másodpercen belül nem adhatod meg kétszer ugyanazt az üzenetet. Miért is tennéd? Ha nem tetted direkt akkor valószínűleg az történt, hogy többször klikkeltél a küldés gombra vagy a frissítés gombra. Ne is törődj vele!</div>'}");
            }
            // label ellenőrzés
            if ($labels == '') {
                $labels = $this->_default_label;
            }
        // insert new msg
        $stmt = $GLOBALS['dbh']->prepare('INSERT INTO messages (type, owner, msg, date) VALUE (?, ?, ?, now())');
        $stmt->execute(array($type, $user_id, $msg));
        $stmt = $GLOBALS['dbh']->prepare('SELECT LAST_INSERT_ID() as mid');
        $stmt->execute();
        $mid = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($type == 2) {
            $this->_last_draft_id = $mid['mid'];
        }
        $label_buff = explode(',', $labels);
        $label_names = array();
        foreach ($label_buff as $label) {
            $label = trim($label);
            if (empty($label)) continue;
            $label_names[] = strtolower($label);
        }
        $label_names = array_unique($label_names);
        foreach ($label_names as $label) {
        	$stmt = $GLOBALS['dbh']->prepare('SELECT lid FROM labels WHERE name = ?');
            $stmt->execute(array($label));
            $lid = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($lid) {
            	$stmt = $GLOBALS['dbh']->prepare('INSERT INTO rellabel (mid, lid) VALUE (?, ?)');
                $stmt->execute(array($mid['mid'], $lid['lid']));
            } else {
            	$stmt = $GLOBALS['dbh']->prepare('INSERT INTO rellabel (mid, lid) VALUE (?, ?)');
                $stmt->execute(array($mid['mid'], 1));
            	/* Új címkéket megadhatnak a felhasználók [NEM ENGEDÉLYEZETT]
            	$stmt = $GLOBALS['dbh']->prepare('INSERT INTO labels (name) VALUE (?)');
                $stmt->execute(array($label));
                $stmt = $GLOBALS['dbh']->prepare('SELECT LAST_INSERT_ID() as lid');
                $stmt->execute();
                $lid = $stmt->fetch(PDO::FETCH_ASSOC);
                $stmt = $GLOBALS['dbh']->prepare('INSERT INTO rellabel (mid, lid) VALUE (?, ?)');
                $stmt->execute(array($mid['mid'], $lid['lid']));
                */
            }
        }
    }
    
    /**
     * Visszavon modosításra egy aktív üzenetet
     * type értéket 3-ra állítja (modosításra visszavonva)
     * 
     * @param int $msg_id visszavonandó üzenet id-je
     * @param int $user_id üzenet tulajdonosa (felhasználói azonosító)
     * @return array state állapotjelentés
     */
    public function repealMsg($msg_id, $user_id)
    {
    	$expire_date = date("Y-m-d H:i:s", time()-$this->_repealmsg_expire);
        $stmt = $GLOBALS['dbh']->prepare('UPDATE messages 
                                          SET type = 3
                                          WHERE id = ? AND
                                                owner = ? AND
                                                date > ?');
        $stmt->execute(array($msg_id, $user_id, $expire_date));
        if ($stmt->rowCount()) {
            return array('state' => 'repeal');
        } else {
        	return array('state' => '',
        	             'error' => '<div class="msg_warning">'.$GLOBALS['st']['error_in_header'].'</div>');
        }
    }
    
     /**
     * A felhasználó egy tervezett (type=2)
     * üzenetét állítja töröltre (type=0)
     * 
     * @param int $msg_id törlendő draft üzenet id-je
     * @param int $user_id üzenet tulajdonosa (felhasználói azonosító)
     * @return array state állapotjelentés
     */
    public function deleteDraftMsg($msg_id, $user_id)
    {
        $stmt = $GLOBALS['dbh']->prepare('UPDATE messages 
                                          SET type = 0
                                          WHERE id = ? AND
                                                owner = ? AND
                                                type != 1');
        $stmt->execute(array($msg_id, $user_id));
        if ($stmt->rowCount()) {
            return array('state' => 'deleted_draft');
        } else {
            return array('state' => '',
                         'error' => '<div class="msg_warning">'.$GLOBALS['st']['error_in_header'].'</div>');
        }
    }
    
    /**
    * Betölti a fórum bejegyzéseket (kivéve a törölteket [type=0])
    * Kiszámítja az összes aktív üzenetek számát [type=1]
    */
    public function loadMsgs()
    {
    	$stmt = $GLOBALS['dbh']->prepare("SELECT COUNT(messages.id) as numrows
                                          FROM messages,
                                               administration
                                          WHERE messages.type = 1 AND
                                                owner = administration.id");
        $stmt->execute();
        $msg_num = $stmt->fetch(PDO::FETCH_ASSOC);
        $this->_msg_num = $msg_num['numrows'];
        
        $stmt = $GLOBALS['dbh']->prepare("SELECT messages.id,
                                                 messages.type,
                                                 administration.name,
                                                 GROUP_CONCAT(labels.name) as 'labels',
                                                 defdragon,
                                                 email,
                                                 msg,
                                                 date
                                          FROM messages,
                                               administration,
                                               rellabel,
                                               labels
                                          WHERE messages.type != 0 AND
                                                owner = administration.id AND
                                                mid = messages.id AND
                                                labels.lid = rellabel.lid
                                          GROUP BY messages.id
                                          ORDER BY messages.id DESC");
        $stmt->execute();
        $msg_data = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_UNIQUE);
        if ($msg_data) {
            $this->_msg_data = $msg_data;
        } else {
        	throw new MyException('Nincs egyetlen üzenet sem!');
        }
    }
    
    /**
    * Betölti az illeszkedő fórum bejegyzéseket
    * a keresett címkékre és/vagy keresett szavakra
    * Működési mód: FULLTEXT SEARCH
    * 
SELECT messages.id,
    messages.type,
    administration.name,
    GROUP_CONCAT(labels.name) as 'labels',
    defdragon,
    email,
    msg,
    date
FROM messages,
    administration,
    rellabel,
    labels
WHERE owner = administration.id AND
    mid = messages.id AND
    labels.lid = rellabel.lid AND
MATCH (msg) 
AGAINST ('harmadik' IN BOOLEAN MODE) AND
MATCH (labels.name) 
AGAINST ('csevegés tiramma' IN BOOLEAN MODE)
GROUP BY messages.id
HAVING COUNT(messages.id) = 2
ORDER BY messages.id DESC
    * 
    * @param string $labels keresett címkék (szünettel elválasztva)
    * @param string $search_type keresés típusa (any,strict)
    * @param string $words keresett szavak (optional)
    */
    public function loadSearchLabelsMsgs($labels, $search_type, $words = '')
    {
    	$execarr = array();
    	$query =                         "SELECT messages.id,
                                                 messages.type,
                                                 administration.name,
                                                 GROUP_CONCAT(labels.name) as 'labels',
                                                 defdragon,
                                                 email,
                                                 msg,
                                                 date
                                          FROM messages,
                                               administration,
                                               rellabel,
                                               labels
                                          WHERE owner = administration.id AND
                                                mid = messages.id AND
                                                labels.lid = rellabel.lid";
    	if ($labels != '') {
            $query .=                         " AND MATCH (labels.name) 
                                                    AGAINST (? IN BOOLEAN MODE)";
            $execarr[] .= $labels;
    	}
    	if ($words != '') {
    		$query .=                         " AND MATCH (msg) 
                                                    AGAINST (? IN BOOLEAN MODE)";
    		$execarr[] .= $words;
    	}
        $query .=                       " GROUP BY messages.id";
        if ($labels != '' && $search_type == 'strict') {
            $query .=                   " HAVING COUNT(messages.id) = ?";
            $labels = trim($labels);
            $word_count = substr_count($labels, ' ');
            $word_count++;
            $execarr[] .= $word_count;
        }
        $query .=                       " ORDER BY messages.id DESC";
        $stmt = $GLOBALS['dbh']->prepare($query);
        $stmt->execute($execarr);
        $msg_data = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_UNIQUE);
        if ($msg_data) {
            $this->_msg_data = $msg_data;
        } else {
        	$this->_msg_data = array();
        }
    }
    
    /**
    * Betölti a címkéket
    */
    public function loadLabels()
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT lid,
                                                 name,
                                                 0
                                          FROM labels UNION
                                          SELECT labels.lid,
                                                 name,
                                                 count(*) as 'db'
                                          FROM labels,
                                               rellabel
                                          WHERE labels.lid = rellabel.lid
                                          GROUP BY name");
        $stmt->execute();
        $labels = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_UNIQUE);
        if ($labels) {
            $this->_labels = $labels;
        } else {
        	throw new MyException('Nincs egyetlen címke sem!');
        }
    }
    
    /**
    * HTML-re formázva adja a bejegyzéseket
    * 
    * @param int $page megjelenítendő oldal
    * @param int $msgs_perpage egy oldalon megjelenített üzenetek száma
    */
    public function getMsgs($page = 0, $msgs_perpage = FORUM_MSGSPERPAGE_NORMAL)
    {
        $html = '';
        $this->_msgs_perpage = intval($msgs_perpage);
        $offset_start = intval($page) * $this->_msgs_perpage;
        $offset_end = $offset_start + $this->_msgs_perpage;
        reset($this->_msg_data);
        $data = current($this->_msg_data);
        $i = 0;
        while ($i < $offset_end) {
            if ($data['type'] == 1) {
                $i++;
                if ($offset_start <= $i) {
                    $html .= '<p><img src="misc/defdragons/small/'.$data['defdragon'].'.gif" alt="'.$GLOBALS['st'][$data['defdragon']].'" /> <span>'.$data['name'].' <span>('.$this->statedTime($data['date']).')</span> '.$data['labels'].' <sup class="msg_id_box_d">#'.key($this->_msg_data).'</sup></span></p>';
                    $msg = htmlspecialchars($data['msg'], ENT_QUOTES);
                    $msg = nl2br($msg);
                    $html .= '<div>'.$msg.'</div>';
                }
            }
            if (false === ($data = next($this->_msg_data))) {
            	break;
            }
        }
        return $html;
    }
    
    /**
    * RSS-XML fájlt készít
    */
    public function getMsgsXML()
    {
        $content  = '<?xml version="1.0" encoding="utf-8"?>';
        $content .= '<rss version="2.0">';
        $content .= '<channel>';
        $content .=   '<title>Kalandok és Sárkányok Fóruma</title>';
        $content .=   '<link>http://danworld.homedns.org/kns</link>';
        $content .=   '<description>A Kalandok és Sárkányok közösségi fórumának hircsatornája.</description>';
        $content .=   '<language>hu</language>';
        $content .=   '<lastBuildDate>'.date("r").'</lastBuildDate>';
        $i = 0;
        foreach ($this->_msg_data as $id => $data) {
        	if ($i < FORUM_RSS_MSGSNUM) {
        	    $i++;
        	} else {
        	    break;
        	}
            if ($data['type'] == 1) {
                $content .= '<item><title>'.$data['name'].'</title>';
                $content .= '<link>http://danworld.homedns.org/kns</link>';
                $content .= '<pubDate>'.date("r",strtotime($data['date'])).'</pubDate>';
                $labels_arr = explode(',', $data['labels']);
                foreach ($labels_arr as $label) {
                    $content .= '<category>'.$label.'</category>';
                }
                $msg = htmlspecialchars($data['msg'], ENT_QUOTES);
                $content .= '<description><![CDATA['.$msg.']]></description></item>';
            }
        }
        $content .= '</channel></rss>';
        file_put_contents('dat/rss.xml',$content);
    }
    
    /**
    * Formázva adja a cimkéket
    */
    public function getLabels()
    {
        $this->loadLabels();
        echo '<div id="labels"><h4 class="hide">Címkék</h4>';
        foreach ($this->_labels as $id => $data) {
            if ($data[0] > $this->_labels_max_size) {
            	$data[0] = $this->_labels_max_size;
            }
            print '<span class="label_s'.$data[0].'">'.$data['name'].'</span> ';
        }
        echo "</div>\n";
    }
    
    /**
    * Formázva adja Tip boxot
    */
    public function getTips()
    {
        echo '<div id="tips">';
        echo '<div id="searchmode_tip"><p class="tip"><sup>Tipp:</sup> Mivel éppen keresel valamit, jelenleg nem frissül a tartalom és nem tudsz üzenetet küldeni. Ha gondolod, kapcsold ki a keresési módot!</p><input type="button" name="searchmodeoff" id="searchmodeoff" value="Befejeztem a keresést!" /></div>';
        echo '<p class="tip"><sup>Tipp:</sup> Használj címkéket az üzenetedhez, hogy később könnyen összekeresdhesd az öszetartozó írásokat! Klikkeld össze a fenti cimkefelhőből vagy kérj újat ha egyikre sem illik rá.</p>';
        echo "</div>\n";
    }
    
    /**
     * Formázva adja a szűrődobozt
     */
    public function filterBox()
    {
       ?>
       <div id="filterbox">
         <h4>Keresés és szűrés</h4>
         <form action="index.php?module=Community" method="post" id="search_box">
             <p><input type="text" name="search" id="search" />
                <input type="button" name="search_go" id="search_go" value="keresés" /></p>
             <p><label><input type="checkbox" name="labels_searchable" id="labels_searchable" />azonnali rákeresés a kijelölt címkékre</label></p>
             <div id="spec_lsearch">
                <p><label><input type="radio" name="labsearch_type" value="any" checked="checked" />a kijelöltek küzül bármelyikkel egyezik</label></p>
                <p><label><input type="radio" name="labsearch_type" value="strict" />szigorúbban egyezik</label></p>
             </div>
             <p><select name="msgs_pager" id="msgs_pager"><option value="0">--</option><?php
             if ($this->_msg_num > $this->_msgs_perpage) {
                $pages = intval($this->_msg_num / $this->_msgs_perpage);
                if ($this->_msg_num % $this->_msgs_perpage) {
                    $pages++;
                }
                for ($i = 1; $i < $pages; $i++) {
                    print '<option value="'.$i.'">'.($i+1).'</option>';
                }
             }
           ?></select> régebbi üzenetek tallózása</p>
         </form>
       </div>
       <?php 
    }
    
    /**
    * Formázva adja az eszköztárat
    * 
    * @param object $user User példány
    */
    public function getTools($user)
    {
        $html_msg = '';
        if ($user) {
            $msg_labels_atr = ' disabled="disabled"';
            $save_msg_atr = '';
            $new_msg_atr = '';
            $msg_atr = '';
            $sysmsg = '';
            
            foreach ($this->_msg_data as $id => $data) {
                if ($data['type'] == 2 &&
                    $data['name'] == $user->name) {
                        if (isset($_POST['return_dmsg']) && $_POST['return_dmsg'] == $id) {
                            $msg = htmlspecialchars($data['msg'], ENT_QUOTES);
                            $msg = nl2br($msg);
                        	$msg_atr = ' value="'.$msg.'"';
                        	$msg_labels_atr = ' disabled="disabled" value="'.$data['labels'].'"';
                        } else {
                        	$msg_atr = '';
                        	$msg_labels_atr = ' disabled="disabled"';
                        }
                    $this->_draft_num++;
                    $msg = htmlspecialchars($data['msg'], ENT_QUOTES);
                    $buff_msg = $this->statedTime($data['date']).' ['.$data['labels'].'] '.$msg;
                    $html_msg .= '<p id="draft_'.$id.'"><span class="msg_id_box">'.$id.'</span><img src="./misc/delete.gif" id="msgdelete_'.$id.'" class="msgdelete_img" alt="üzenet törlése" title="üzenet törlése" /> '.mb_strimwidth($buff_msg, 0, $this->_draft_maxchar, "...").'</p>';
                }
            }
        } else {
            $msg_atr = ' disabled="disabled" ';
            $msg_labels_atr = ' disabled="disabled"'; // csak itt disabled ha engedélyezett az új labels-ek megadása
            $save_msg_atr = ' disabled="disabled"';
            $new_msg_atr = ' disabled="disabled"';
            $sysmsg = '<span class="msg_alert">Be kell jelentkezned!</span>';
        }
        
        $html = '<div id="msg_tools">';
        $html .= '<h4 class="hide">Új üzenet feladása</h4>';
        $html .= '<form action="index.php?module=Community" method="post" id="forummsg">';
        $html .= '<p><textarea name="msg" id="msg" rows="8" cols="25" '.$msg_atr.'></textarea></p><p>Címkék: <input type="text" name="msg_labels" id="msg_labels"'.$msg_labels_atr.' /> <input type="button" name="save_msg" id="save_msg" value="piszkozat"'.$save_msg_atr.' /> <input type="button" name="new_msg" id="new_msg" value="küldés"'.$new_msg_atr.' /></p>';
        $html .= '</form>';
        if ($sysmsg) {
        	$html .= $sysmsg;
        } else {
        	$html .= '<p><span id="msg_autosave_box"><span id="msg_id" class="msg_id_box"></span> <label><input type="checkbox" name="msg_autosave" id="msg_autosave" checked="checked"> automatikus mentés</label></span></p>';
            $html .= '<ul class="button">';
            $html .= '<li><span id="draft_tool" class="abutton">van <span id="draft_num">'.$this->_draft_num.'</span> piszkozatod </span></li>';
            $html .= '</ul>';
            $html .= '<div id="draft_messages">';
            $html .= '<h4 class="hide">Piszkozatok</h4>';
            $html .= $html_msg;
            $html .= '</div>';
        }
        $html .= '</div>';
        print $html;
    }
    
    /**
    * új üzenet html visszaadása
    * 
    * @param string $last_msg_id az utolsó megjelenített
    *                            üzenet a kliensoldalon
    * @return string új kliensoldalon beszúrandó üzenet html-ben
    */
    public function getNewMsgs($last_msg_id)
    {
    	if ($last_msg_id == '0') {
    	    $this->loadMsgs();
            return $this->getMsgs();
    	}
        $stmt = $GLOBALS['dbh']->prepare("SELECT messages.id,
                                                 messages.type,
                                                 administration.name,
                                                 GROUP_CONCAT(labels.name) as 'labels',
                                                 defdragon,
                                                 email,
                                                 msg,
                                                 date,
                                                 messages.specowner
                                          FROM messages,
                                               administration,
                                               rellabel,
                                               labels
                                          WHERE messages.id > ? AND
                                                owner = administration.id AND
                                                mid = messages.id AND
                                                labels.lid = rellabel.lid
                                          GROUP BY messages.id
                                          ORDER BY messages.id DESC");
        $stmt->execute(array($last_msg_id-5)); // -5 : ennyivel régebbi viszavont üzenetet keres
        $msg_data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        $new_msg = '';
        if ($msg_data) {
            foreach ($msg_data as $data) {
                if ($data['id'] > $last_msg_id && $data['type'] == 1) {
                    if ($GLOBALS['user'] &&
                        $GLOBALS['user']->name == $data['name'] &&
                        $last_msg_id != '0' &&
                        empty($data['specowner'])) {
                        $modify = ' <span id="msg_modify">még gyorsan módosíthatod</span>';
                    } else {
                        $modify = '';
                    }
                    $buff = htmlspecialchars($data['msg'], ENT_QUOTES);
                    $buff = nl2br($buff);
            	    $new_msg .= '<p><img src="misc/defdragons/small/'.$data['defdragon'].'.gif" alt="'.$GLOBALS['st'][$data['defdragon']].'" /> <span>'.$data['name'].' <span>('.$this->statedTime($data['date']).')</span> '.$data['labels'].' <sup class="msg_id_box_d">#'.$data['id'].'</sup>'.$modify.'</span></p><div>'.$buff.'</div>';
                } elseif ($data['type'] == 3) {
                	$this->_repeal_msgs_id[] = $data['id'];
                } elseif ($data['id'] == $this->_last_draft_id) {
                    $msg = htmlspecialchars($data['msg'], ENT_QUOTES);
                    $buff_msg = $this->statedTime($data['date']).' ['.$data['labels'].'] '.$msg;
                    $new_msg .= '<p id="draft_'.$data['id'].'"><span class="msg_id_box">'.$data['id'].'</span><img src="./misc/delete.gif" id="msgdelete_'.$data['id'].'" class="msgdelete_img" alt="üzenet törlése" title="üzenet törlése" /> '.mb_strimwidth($buff_msg, 0, $this->_draft_maxchar, "...").'</p>';
                }
            }
        }
        return $new_msg;
    }
    
    /**
     * Visszaadja a módosításra a visszavont üzenetek id-jét
     * 
     * Előtte meg kell hívni a getNewMsgs függvényt mert az
     * tölti fel a _repeal_msgs_id változót 
     *
     * @return string visszavont (type=3) üzenetek id-je
     *                vesszővel elválasztva
     */
    public function getRepealMsgsId()
    {
    	return implode(',',$this->_repeal_msgs_id);
    }
    
    /**
     * Visszaadja egy kért elem id üzenet és cimke
     * részét tömben
     * 
     * @param int $msg_id kért üzenet id-je
     * @return array id, címkék, üzenet
     */
    public function getMsg($msg_id)
    {
        $stmt = $GLOBALS['dbh']->prepare("SELECT messages.id,
                                                 messages.type,
                                                 administration.name,
                                                 GROUP_CONCAT(labels.name) as 'labels',
                                                 defdragon,
                                                 email,
                                                 msg,
                                                 date
                                          FROM messages,
                                               administration,
                                               rellabel,
                                               labels
                                          WHERE messages.id = ? AND
                                                owner = administration.id AND
                                                mid = messages.id AND
                                                labels.lid = rellabel.lid
                                          GROUP BY messages.id
                                          ORDER BY messages.id DESC");
        $stmt->execute(array($msg_id));
        $msg = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($msg) {
            return array('msgid'     => $msg['id'],
                         'msglabels' => $msg['labels'],
                         'msg'       => $msg['msg']);
        } else {
            return array('msgid'     => 0,
                         'msglabels' => '',
                         'msg'       => '');
        }
    }
    
    /**
    * Megadja az eltelt idő formás alakját
    * pl.: 1 órája, tegnap stb..
    * 
    * @param string $datetime idő bemenet (pl 2008-08-28 22:58:27)
    * @return string formázott kimenet
    */
    public function statedTime($datetime)
    {
        $now = new DateTime();
        $dtm = new DateTime($datetime);
        if ($now->format('Y') == $dtm->format('Y')) {
            $offset_d = $now->format('z') - $dtm->format('z');
        } else {
        	$offset_d = 400;
        }
        switch ($offset_d) {
            case 0:
                $offset_s = $now->format('U') - $dtm->format('U');
                if ($offset_s < 3600) {
                    if ($offset_s < 60) {
                    	$return = 'épp most';
                    } else {
                    	$return = (int)($offset_s / 60).' perce';
                    }
                } elseif ($offset_s < 32400) {
                	$return = (int)($offset_s / 3600).' órája';
                } else {
                	$return = $dtm->format('H:i');
                }
                break;
            case 1:
                $return = 'tegnap '.$dtm->format('H:i');
                break;
            case 2:
                $return = 'tegnapelőtt '.$dtm->format('H:i');
                break;
            default:
                if ($offset_d == 400) {
                    $return = $dtm->format('Y M. j. H:i');
                } else {
                	$return = $dtm->format('M. j. H:i');
                }
        }
        return '<span class="msg_time">'.$return.'</span>';
    }
}

define("FORUM_SYNC_STATE_READY", "Szinkronizációra kész...");
define("FORUM_SYNC_STATE_READOK", "Beolvasás sikeres...");
define("FORUM_SYNC_STATE_FILTEROK", "A régi üzentek kiszűrése befejeződött...");
define("FORUM_SYNC_STATE_ERROR_READ", "Sajnos a szinkronizáció nem sikerült!");

/**
 * Szinkronizáció közben keletkező kivételek
 */
class Forum_SyncException extends MyException {};

/**
 * A régi fórummal szinkronizáló eszköztár
 */
class Forum_Sync
{
	/**
	 * Szinkronizáció állapota
	 *
	 * @var string $state
	 */
    public $state;
	
	/**
	 * régi fórum beolvasási url-je
	 *
	 * @var string $read_target
	 */
	public $read_target = "http://sgforum.hu/listazas.php3?azonosito=kalandokessarkanyok&id=1090251243";
	// punk: public $read_target = "http://sgforum.hu/listazas.php3?azonosito=kalandokessarkanyok&id=1094825603";
	
	/**
	 * Beolvasott üzeneteket tartalmazó
	 * tömb
	 *
	 * @var array $msgs 
	 */
	public $msgs = array();
	
	/**
     * Beolvasott üzenetek tulajdonosát
     * tartalmazó tömb
     *
     * @var array $users 
     */
    public $users = array();
    
    /**
     * Beolvasott üzenetek időpontját
     * tartalmazó tömb
     *
     * @var array $msgtime
     */
    public $msgtime = array();
	
	/**
     * régi fórumból beolvasott oldal
     *
     * @var string $_read_content
     */
    private $_page_content;
    
    /**
     * régi fórum utoljára szinkronizált
     * üzenetének id-je
     * 
     * @var $_last_sync_msgid
     */
    private $_last_sync_msgid;
    
    /**
    * Régi és új felhasználók szinkronizációja
    * 
    * @var array $_syncusers
    * 
    * 89   Bobak
    * 88   Danechou
    * 16   danworld
    * 87   Antimor
    * 50   _Agreis
    * 51   _Melan
    * 52   _Darakmoon
    * 90   ronin
    * 53   _Sztyepan
    * 54   _Antracit
    * 55   _Bali
    * 56   _Melinda
    */
    private $_syncusers = array(
            'Nalkhor' => 89,
            'Danechou' => 88,
            'Dw' => 16,
            'Ris' => 87,
            'Agreis' => 50,
            'ser' => 51,
            'Lord Darak-moon' => 52,
            'ronin' => 90,
            'Sztyepan' => 53,
            'serr' => 51,
            'Antimor' => 87,
            'marci' => 51,
            'Melan' => 51,
            'asdf' => 51,
            'Meli' => 51,
            'serbor' => 51,
            'ronin444444444' => 90,
            'stofferg@freeweb.hu' => 87,
            'Antracit' => 54,
            'melan, a trollok réme' => 51,
            'stofferg@freemail.hu' => 87,
            'melanka' => 51,
            'amitráz' => 54,
            'amitraz' => 54,
            'Bali' => 55,
            'Gomez' => 51,
            'melinda' => 56,
            'bobakk' => 89,
            'M' => 51,
            'Antimot' => 87,
            'Minden halott fura Ura' => 87,
            'Tűzmágus mester' => 16,
            'gergo.vofely@gmail.com' => 89,
            'házisárkány' => 89
    );
	
	/**
	 * Constructor
	 * 
	 * 
	 */
	public function __construct()
	{
        $this->state = FORUM_SYNC_STATE_READY;
	}
    
	/**
	 * Beolvassa a régi fórum első oldalát
	 */
    public function syncRead()
    {
        if ($buffer = file_get_contents($this->read_target, 'ISO-8859-2')) {
        	$this->_page_content = mb_convert_encoding($buffer, 'UTF-8', 'ISO-8859-2');
            $this->state = FORUM_SYNC_STATE_READOK;
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Sikertelen betőltés!)';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
    }
    
    /**
     * Kiszűri a betőltött oldalon található
     * üzeneteket és azok jellemzőit
     */
    public function filterProperty()
    {
        $order = array("\r\n", "\n", "\r");
        $replace = ' ';
        $this->_page_content = str_replace($order, $replace, $this->_page_content);
    	// régi üzenetek id-jének kiszűrése
    	$pattern = '/(A NAME=")(\d+)/';
    	if (preg_match_all($pattern, $this->_page_content, $buffer)) {
    		$msgids = $buffer[2];
    	} else {
    		$this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az ID-k kiszűrése közben hiba történt!)';
    		throw new Forum_SyncException(json_encode(array('error' => $this->state)));
    	}
    	// üzenet szövegének kiszűrése
        $pattern = '/(<SPAN id=maskwindow class=maskwindow>)(.+?)(<\/SPAN>)/';
        if (preg_match_all($pattern, $this->_page_content, $buffer)) {
            $msgs = $buffer[2];
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetek tartalmának kiszűrése közben hiba történt! [preg])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        if ($buffer = array_combine($msgids, $msgs)) {
        	foreach ($buffer as $id => $msg) {
                $patterns[0] = '/<br>/';
                $replaces[0] = "\n";
                $this->msgs[$id] = preg_replace($patterns, $replaces, $msg);
        	}
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetek tartalmának kiszűrése közben hiba történt! [combine])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        // üzenet tulajdonosának kiszűrése
        // regex régiek: /(TITLE="|s\'\);return true" ONMOUSEOUT="JavaScript:mu\(\)">|CLASS="msgtopic">&nbsp;)([^<].*?)("|<\/A>|<\/TD>)/
        // regex újak: /(TITLE="|s\'\);return true" ONMOUSEOUT="JavaScript:mu\(\)">)(.*?)("|<\/A>)/
        $pattern = '/(TITLE="|s\'\);return true" ONMOUSEOUT="JavaScript:mu\(\)">|CLASS="msgtopic">&nbsp;)([^<].*?)("|<\/A>|<\/TD>)/';
        if (preg_match_all($pattern, $this->_page_content, $buffer)) {
            $users = $buffer[2];
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetek tulajdonosának kiszűrése közben hiba történt! [preg])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        if ($buffer_pre = array_combine($msgids, $users)) {
            foreach ($buffer_pre as $id => $user) {
        	   $buffer_trueusers[$id] = str_replace('&copy; ', '', $user);
            }
            $this->users += $buffer_trueusers;
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetek tulajdonosának kiszűrése közben hiba történt! [combine])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        // üzenetfeladás időpontjának kiszűrése
        $pattern = '/(WIDTH="60%" CLASS="msgtopic">)(.+?)(&nbsp;|&nbsp;<A)/';
        if (preg_match_all($pattern, $this->_page_content, $buffer)) {
            $msgtime = $buffer[2];
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetfeladás időpontjának kiszűrése közben hiba történt! [preg])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        if ($buffer = array_combine($msgids, $msgtime)) {
        	foreach ($buffer as $id => $date) {
        		$pattern = '/(^[\d]{4})(..)(.+)(..)([\d]{2})(..)([\d]{2})(:)([\d]{2})/';
        		if (preg_match_all($pattern, $date, $split_date)) {
        			$month_hu = array(
        			    'jan'   => '01',
        			    'feb'   => '02',
        			    'márc'  => '03',
        			    'ápr'   => '04',
        			    'máj'   => '05',
        			    'jún'   => '06',
        			    'júl'   => '07',
        			    'aug'   => '08',
        			    'szept' => '09',
        			    'okt'   => '10',
        			    'nov'   => '11',
        			    'dec'   => '12'
        			);
        			if (array_key_exists($split_date[3][0], $month_hu)) {
        				$month =  $month_hu[$split_date[3][0]];
        			} else {
        			    $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetfeladás időpontjának kiszűrése közben hiba történt! [month_hu])';
                        throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        			}
        			$formated_date = $split_date[1][0].'-'.$month.'-'.$split_date[5][0].' '.$split_date[7][0].':'.$split_date[9][0].':00';
        		} else {
        			$pattern = '/(^ma|tegnap)(.)([\d]{2})(:)([\d]{2})/';
        			if (preg_match_all($pattern, $date, $split_date)) {
        				if ($split_date[1][0] == 'ma') {
        			        $formated_date = date('Y-m-d').' '.$split_date[3][0].':'.$split_date[5][0].':00';
        				} else if ($split_date[1][0] == 'tegnap') {
        					$formated_date = date('Y-m-d', strtotime("-1 day")).' '.$split_date[3][0].':'.$split_date[5][0].':00';
        				} else {
        				    $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetfeladás időpontjának kiszűrése közben hiba történt! [split-now])';
                            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        				}
        			} else {
        				$this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetfeladás időpontjának kiszűrése közben hiba történt! [split])';
                        throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        			}
        		}
        	    $this->msgtime[$id] = $formated_date;
        	}
        } else {
            $this->state = FORUM_SYNC_STATE_ERROR_READ.' (Az üzenetfeladás időpontjának kiszűrése közben hiba történt! [combine])';
            throw new Forum_SyncException(json_encode(array('error' => $this->state)));
        }
        $this->state = FORUM_SYNC_STATE_FILTEROK;
    }
    
    /**
     * Az új üzeneteket szinkronizálja a
     * régi fórumból
     */
    public function newMsgs()
    {
        $this->syncRead();
        $this->filterProperty();
        
        ksort($this->msgtime);
        ksort($this->msgs);
        ksort($this->users);
        
        //print_r($this->msgtime);
        //print_r($this->msgs);
        //print_r($this->users);
        
        $xml = simplexml_load_file('dat/sync_oldforum.xml');
        $this->_last_sync_msgid = $xml->last_sync_msgid;
        $new_last_sync_msgid = false;
        
        foreach ($this->msgs as $specid => $msg) {
        	if ($this->_last_sync_msgid < $specid) {
        		print $this->_last_sync_msgid.' < '.$specid.' szinkronizációja...';
        	    if (array_key_exists($this->users[$specid], $this->_syncusers)) {
                    $owner = $this->_syncusers[$this->users[$specid]];
                } else {
                    $owner = 3; // 3 - régifórum user
                }
                $stmt = $GLOBALS['dbh']->prepare('INSERT INTO messages (type, owner, msg, date, specid, specowner) VALUE (1, ?, ?, ?, ?, ?)');
                $stmt->execute(array($owner, $msg, $this->msgtime[$specid], $specid, $this->users[$specid]));
                $stmt = $GLOBALS['dbh']->prepare('SELECT LAST_INSERT_ID() as mid');
                $stmt->execute();
                $mid = $stmt->fetch(PDO::FETCH_ASSOC);
                $stmt = $GLOBALS['dbh']->prepare('INSERT INTO rellabel (mid, lid) VALUE (?, 2)');
                $stmt->execute(array($mid['mid']));
                $new_last_sync_msgid = $specid;
                print ' kész<br />';
            }
        }
        
        if ($new_last_sync_msgid !== false) {
        	$xml->last_sync_msgid = $new_last_sync_msgid;
        	$xml->asXML('dat/sync_oldforum.xml');
        }
    }
    
    /**
     * Az öszes üzenetet áttőlti a
     * régi fórumból
     */
    public function fullSync()
    {
    	$oldforum_pre = 'http://sgforum.hu/listazas.php3?id=1090251243&order=reverse&index=';
        $oldforum_aft = '&azonosito=kalandokessarkanyok';
        
        // az összes üzenet áttőltése (pages 68)
        for ($i = 1; $i < 68; $i++) {
        	$this->read_target = $oldforum_pre.$i.$oldforum_aft;
        	$this->syncRead();
        	$this->filterProperty();
        }
        
        ksort($this->msgtime);
        ksort($this->msgs);
        ksort($this->users);
        
        //print_r($this->msgtime);
        //print_r($this->msgs);
        //print_r($this->users);
        
        foreach ($this->msgs as $specid => $msg) {
        	if (array_key_exists($this->users[$specid], $this->_syncusers)) {
        		$owner = $this->_syncusers[$this->users[$specid]];
        	} else {
        		$owner = 3; // 3 - régifórum user
        	}
            $stmt = $GLOBALS['dbh']->prepare('INSERT INTO messages (type, owner, msg, date, specid, specowner) VALUE (1, ?, ?, ?, ?, ?)');
            $stmt->execute(array($owner, $msg, $this->msgtime[$specid], $specid, $this->users[$specid]));
            $stmt = $GLOBALS['dbh']->prepare('SELECT LAST_INSERT_ID() as mid');
            $stmt->execute();
            $mid = $stmt->fetch(PDO::FETCH_ASSOC);
            $stmt = $GLOBALS['dbh']->prepare('INSERT INTO rellabel (mid, lid) VALUE (?, 2)');
            $stmt->execute(array($mid['mid']));
        }
    }
}

?>