<?php

/**
* Felhasználói tevékenység nyomonkövetése
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2008 danworld page
*/

/**
* követő objektum
*/
class Watchusers
{
    /**
     * felhasználó aktuális tevékenysége
     * kulcsa az action_descript tömbnek
     * 
     * @var int $action;
     */
    public $action;
    
    /**
     * a tevékenységek leírását tartalmazó
     * tömb
     * 
     * @var array $action_descript;
     */
    public $action_descript = array(
                0  => 'nem tudni mit csinál',
                1  => 'itt van',
                2  => 'éppen üzenetet ír'
    );
    
    /**
     * token lejárati idő (másodpercben)
     * 
     * ha egy tokent azonosít a táblában (hit)
     * ellenőrzi, hogy ennél az időnél régebbi
     * volt e az utolsó találat (touch), ha igen
     * új tokent indít
     * 
     * @var int $_hit_expire; 
     */
    private $_hit_expire = 90;
    
    /**
     * constructor
     * 
     * Adatbázisba menti a felhasználó adatait és egy tokent indít
     * illetve folytat egy megkezdett tokent
     */
    public function __construct()
    {
        $this->setAction();
        $stmt = $GLOBALS['dbh']->prepare('SELECT touch_first, touch
                                          FROM watchusers
                                          WHERE token = ?');
        $stmt->execute(array(session_id()));
        $hit = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($hit && (
                ($hit['touch'] > (time()-$this->_hit_expire)) ||
                ($hit['touch_first'] > (time()-$this->_hit_expire))
            )) {
            //print('HIT '.session_id());
            if (isset($_GET['screen_res']) && isset($_GET['screen_col'])) {
            	$stmt = $GLOBALS['dbh']->prepare('UPDATE watchusers
                                                  SET touch = ?,
                                                      action = ?,
                                                      screen_resolution = ?,
                                                      screen_colour = ?
                                                  WHERE token = ?');
                $stmt->execute(array(time(),
                                     $this->action,
                                     $this->sgVal($_GET, 'screen_res', 50),
                                     $this->sgVal($_GET, 'screen_col', 20),
                                     session_id()));
            } else {
                $stmt = $GLOBALS['dbh']->prepare('UPDATE watchusers
                                                  SET touch = ?,
                                                      action = ?
                                                  WHERE token = ?');
                $stmt->execute(array(time(), $this->action, session_id()));
            }
        } else {
            //print('MISS');
            session_regenerate_id();
            $stmt = $GLOBALS['dbh']->prepare('INSERT INTO watchusers 
                                                        (token,
                                                         ip,
                                                         touch_first,
                                                         touch,
                                                         cookie_token,
                                                         cookie_ver,
                                                         cookie_created,
                                                         uid,
                                                         action,
                                                         module,
                                                         method,
                                                         request_uri,
                                                         port,
                                                         request_time,
                                                         referer,
                                                         accept,
                                                         accept_language,
                                                         accept_encoding,
                                                         accept_charset,
                                                         keep_alive,
                                                         connection,
                                                         cache_control,
                                                         user_agent,
                                                         content_type,
                                                         x_requested_width,
                                                         content_length,
                                                         pragma,
                                                         request_serialize,
                                                         screen_resolution,
                                                         screen_colour,
                                                         error)
                                                 VALUE (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
        $stmt->execute(array(session_id(),                                         //token,
                             $this->sgVal($_SERVER, 'REMOTE_ADDR', 40),            //ip,
                             time(),                                               //touch_first,
                             0,                                                    //touch
                             $this->sgVal($_COOKIE, Cookie::$cookie_name, 2000),   //cookie_token,
                             NULL,                                                 //cookie_ver,
                             NULL,                                                 //cookie_created,
                             0,                                                    //uid,
                             $this->action,                                        //action,
                             $this->sgVal($_GET, 'module', 20),                    //module,
                             $this->sgVal($_SERVER, 'REQUEST_METHOD', 10),         //method,
                             $this->sgVal($_SERVER, 'REQUEST_URI', 2000),          //request_uri,
                             $this->sgVal($_SERVER, 'REMOTE_PORT', 65535, 1),      //port,
                             $this->sgVal($_SERVER, 'REQUEST_TIME', 4294967295, 1),//request_time,
                             $this->sgVal($_SERVER, 'HTTP_REFERER', 2000),         //referer,
                             $this->sgVal($_SERVER, 'HTTP_ACCEPT', 2000),          //accept,
                             $this->sgVal($_SERVER, 'HTTP_ACCEPT_LANGUAGE', 2000), //accept_language,
                             $this->sgVal($_SERVER, 'HTTP_ACCEPT_ENCODING', 2000), //accept_encoding,
                             $this->sgVal($_SERVER, 'HTTP_ACCEPT_CHARSET', 2000),  //accept_charset,
                             $this->sgVal($_SERVER, 'HTTP_KEEP_ALIVE', 2000),      //keep_alive,
                             $this->sgVal($_SERVER, 'HTTP_CONNECTION', 2000),      //connection,
                             $this->sgVal($_SERVER, 'HTTP_CACHE_CONTROL', 2000),   //cache_control,
                             $this->sgVal($_SERVER, 'HTTP_USER_AGENT', 2000),      //user_agent,
                             $this->sgVal($_SERVER, 'CONTENT_TYPE', 2000),         //content_type,
                             $this->sgVal($_SERVER, 'HTTP_X_REQUESTED_WITH', 2000),//x_requested_width,
                             $this->sgVal($_SERVER, 'CONTENT_LENGTH', 4294967295), //content_length,
                             $this->sgVal($_SERVER, 'HTTP_PRAGMA', 2000),          //pragma,
                             mb_strimwidth(serialize($_REQUEST), 0, 10000, "..."), //request_serialize,
                             NULL,                                                 //screen_resolution,
                             NULL,                                                 //screen_colour,
                             'Nincs hiba'                                          //error
                             ));
        }
    }
    
    /**
     * A tokenhez egy userID-t rendel ha van
     * kiegészítve a hozzá tartozó auth-cookie értékeivel
     * 
     * @param object $cookie a felhasználó feldolgozott auth-cookie-ja
     */
    public function setAuthParam($cookie)
    {
        if ($cookie) {
            $stmt = $GLOBALS['dbh']->prepare('UPDATE watchusers
                                              SET cookie_token = ?,
                                                  cookie_ver = ?,
                                                  cookie_created = ?,
                                                  uid = ?
                                              WHERE token = ?');
            $stmt->execute(array($this->sgVal($_COOKIE, Cookie::$cookie_name, 2000),
                                 $cookie->version, 
                                 $cookie->created,
                                 $cookie->user_id,
                                 session_id()));
        }
    }
    
    /**
     * Elmenti a tokenhez tartozó hibát
     * 
     * @param string $error hibaüzenet
     */
    public function setErrorReport($error = 'Nincs hiba')
    {
        if ($error) {
            $stmt = $GLOBALS['dbh']->prepare('UPDATE watchusers
                                              SET error = concat_ws(" ",`error`,?)
                                              WHERE token = ?');
            $stmt->execute(array($error,
                                 session_id()));
        }
    }
    
    /**
     * Beállítja a felhasználó aktuális
     * tevékenységé (action)
     */
    public function setAction()
    {
        if (isset($_GET['change_msg']) && $_GET['change_msg'] == '2') {
            $this->action = 2;
        } else {
            $this->action = 1;
        }
    }
    
    /**
     * Visszaadja a felhasználók tevékenységeit
     * 
     * @param object $user felhasználó objektuma
     * @return string formázott kimenet tevékenységek listája
     */
    public function getActions()
    {
        $stmt = $GLOBALS['dbh']->prepare('SELECT token, uid, defdragon, name, ip, action
                                          FROM watchusers, administration
                                          WHERE uid IS NOT NULL AND
                                                action IS NOT NULL AND
                                                (
                                                    touch > ? OR
                                                    touch_first > ?
                                                ) AND
                                                uid = id');
        $valid_action_time = time()-20;
        $stmt->execute(array($valid_action_time, $valid_action_time));
        $hit = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($hit) {
        	$html = '<div id="usrs_action"><h4>Ki van itt?</h4><ul>';
            foreach ($hit as $data) {
                if (empty($data['uid']) && ($data['token'] == session_id())) {
                    $html .= '<li><img src="misc/defdragons/small/'.$data['defdragon'].'.gif" alt="'.$GLOBALS['st'][$data['defdragon']].'" /> <span>Személyed <span class="ip">'.$data['ip'].'</span> ip címen '.$this->action_descript[$data['action']].'</span></li>';
                } elseif (!empty($data['uid'])) {
                    $html .= '<li><img src="misc/defdragons/small/'.$data['defdragon'].'.gif" alt="'.$GLOBALS['st'][$data['defdragon']].'" /> <span>'.$data['name'].' '.$this->action_descript[$data['action']].'</span></li>';
                } else {
                    $html .= '<li><img src="misc/defdragons/small/'.$data['defdragon'].'.gif" alt="'.$GLOBALS['st'][$data['defdragon']].'" /> <span>Valaki <span class="ip">'.$data['ip'].'</span> ip címen '.$this->action_descript[$data['action']].'</span></li>';
                }
            }
            $html .= '</ul></div>';
            return $html;
        } else {
        	return '<div class="msg_warning">Nincs itt senki? Az nem lehet ha ezt olvasod... Töltsd be újra az oldalt!</div>';
        }
    }
    
    /**
    * SUPERGLOBAL ellenőrző eszköz
    * 
    * @param array $sg ellenőrizendő SUPERGLOBAL változó
    * @param string $key ellenőrizendő tömb kulcsa
    * @param integer $type típus (0-string, 1-int) def 0
    * @param integer $max_length hosz max def 0
    * @param integer $min_length hosz min def 0
    * @return string az ellenőrizett érték, hiba esetén NULL(string)
    */
    public function sgVal($sg, $key, $max_length = 0, $type = 0, $min_length = 0)
    {
        $fail = NULL;
        if (array_key_exists($key, $sg)) {
            if ($type) {
                if (!ctype_digit($sg[$key])) {
                    return $fail;
                }
                if (($max_length && ((int)$sg[$key] > $max_length)) || 
                    ($min_length && ((int)$sg[$key] < $min_length))) {
                    return $fail;
                }
            } elseif (($max_length && (strlen($sg[$key]) > $max_length)) || 
                      ($min_length && (strlen($sg[$key]) < $min_length))) {
                return mb_strimwidth($sg[$key], 0, ($max_length-3), "...");
            }
        } else {
            return $fail;
        }
        return $sg[$key];
    }
}