<?php

/**
* Rgi adatbzis kapcsolati objektum rtegek
* 
* Hasznlaton kvl!
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

/**
* Adatbzis kezel
* 
* A mysqli osztly burkolja, sajt kivteleket
* (MyException objektumot) dob ha hiba keletkezik
* valamelyik metdusban, ellenben megsznteti az
* eredeti hibajelz return rtkeket (nincs false
* visszatrsk, de true van)
*/
class DB_Sql extends mysqli
{
    /**
    * Constructor
    * 
    * Adatbzis kapcsolatot hoz ltre
    * 
    * @param string $host adatbzis host
    * @param string $user adatbzisba bejelentkez felhasznl
    * @param string $pwd  felhasznl jelszava
    * @param string $dbname adatbzis neve
    * @return object visszaad egy objektumot, ami a kapcsolatot kpviseli
    *                egy MySQL szerverhez
    * @throws hiba esetn MyException objektum keletkezik
    */
    public function __construct($host, $user, $pwd, $dbname)
    {
        @parent::__construct($host, $user, $pwd, $dbname);
        if (mysqli_connect_errno()) {
        	throw new MyException(DB_ERROR);
        }
    }
    
    /**
    * Elkszt egy lekrdezst egy sajt
    * DB_Stmt (mysqli_stmt gyermeke)-ben
    * 
    * @param string $pre_query elksztend lekrdezs
    * @return object lekrdezs kivonat (statement) DB_Stmt
    */
    public function prepare($pre_query)
    {
        $stmt = new DB_Stmt($this, $pre_query);
        return $stmt;
    }

    /**
    * Vgrehajt egy lekrdezst
    * 
    * @param string $query vgrehajtand lekrdezs
    * @return object lekrdezs eredmnye
    * @throws hiba esetn MyException objektum keletkezik
    */
    public function query($query)
    {
        if ($result = @parent::query($query)) {
        	return $result;
        } else {
        	throw new MyException(DB_ERROR);
        }
    }
    
}

/**
* Adatbzis kivonat (statement) kezel
* 
* A mysqli_stmt osztly burkolja, sajt kivteleket
* (MyException objektumot) dob ha hiba keletkezik
* valamelyik metdusban
* 
* !!! bug (2): Sajnos azokat a metdusokat amik vltoz
* hosszsg paramterlistval dologznak pl.
* bind_param() nem sikerlt tkletesen burkolni gy 
* ezekhez nincs kivtelkezels sem teht a 
* hiba-kimenetket le kell tiltani (@)
* jelenleg emiatt nem lettek implementlva a kvetkezk
* br a parent:: -jk elrhet:
* 1. bind_param hasznld ehelyette a kibvtett 
*    tulajdonsgokkal br ext_bind_param-ot
* 2. bind_result
*/
class DB_Stmt extends mysqli_stmt
{
    /**
    * Segtsgvel ellenrizhet, hogy lett e mr
    * csatlakoztatva metaadat pl. a fetch_assoc()
    * metdusban
    * 
    * @var bool $is_bound_metadata
    */
    protected $is_bound_metadata = false;
    
    /**
    * Az eredmnytmb ideiglenes trolja
    * csak a kulcsok tltdnek fel benne
    * (a fetch_assoc() metdus hasznlja)
    * 
    * @var array $results
    */
    protected $results;
    
    /**
    * Constructor
    * 
    * @param object $link mysqli szl
    * @param string $query elksztett lekrdezs
    */
    public function __construct($link, $query)
    {
        parent::__construct($link, $query);
    }
    
    /**
    * Paramter-vltozk csatolsa elksztett
    * lekrdezshez
    * 
    * megj: lnyegben egyelre a beptett
    * bind_param-ot hvja meg
    * 
    * @param  mixed vltoz paramterszm bemenet
    * @return bool true ha nincs hiba
    * @throws hiba esetn MyException objektum keletkezik
    */
    public function ext_bind_param()
    {
        $args = func_get_args();
        if (@call_user_func_array(array($this, 'parent::bind_param'), $args)) {
        	return true;
        } else {
            throw new MyException(DB_ERROR);
        }
    }
    
    /**
    * Vgrehajt egy elksztett lekrdezst
    * 
    * @return bool true ha nincs hiba
    * @throws hiba esetn MyException objektum keletkezik
    */
    public function execute()
    {
        if (@parent::execute()) {
        	return true;
        } else {
            throw new MyException(DB_ERROR);
        }
    }
    
    /**
    * Kiteszi az eredmny egy sort a bind_result-ban
    * megadott vltozkba
    * 
    * @return bool true ha rendben, null ha vge
    * @throws hiba esetn MyException objektum keletkezik
    */
    public function fetch()
    {
        $return = @parent::fetch();
        if ($return === false) {
            throw new MyException(DB_ERROR);
        } else {
            return $return;
        }
    }
    
    /**
    * A result kvetkez sorval, mint asszociatv tmbbel tr vissza
    * 
    * @return array a result egy sora mint tmb (null ha nincs tbb sor)
    */
    public function fetch_assoc()
    {
        if (!$this->is_bound_metadata) {
            $meta = $this->result_metadata();
            while ($column = $meta->fetch_field()) {
                $column_name = str_replace(' ', '_', $column->name);
                $bind_vars[] = &$this->results[$column_name];
            }
            call_user_func_array(array($this, 'bind_result'), $bind_vars);
            $this->is_bound_metadata = true;
        }
        if ($this->fetch() !== null) {
            foreach ($this->results as $key => $value) {
                $results[$key] = $value;
            }
            return $results;
        } else {
            return null;
        }
    }
}


/**
* Adatbzis kezel
* 
* (a rgi mysql extension-hz)
*/
class DB_Mysql
{
    /**
    * Adatbzishoz tartoz felhasznli nv
    * 
    * @var string $user
    */
    protected $user;
    
    /**
    * Adatbzishoz tartoz jelsz
    * 
    * @var string $pwd
    */
    protected $pwd;
    
    /**
    * Adatbzis host
    * 
    * @var string $host
    */
    protected $host;
    
    /**
    * Adatbzis neve
    * 
    * @var string $dbname
    */
    protected $dbname;
    
    /**
    * Adatbzis kapcsolat
    * 
    * @var resource $dbconnect
    */
    protected $dbconnect;
    
    /**
    * Constructor
    * 
    * Feltlti az adatbziskapcsolathoz
    * szksges vltozkkal az Objektumot
    * 
    * @param string $db_user adatbzishoz tartoz felhasznli nv
    * @param string $db_pwd adatbzishoz tartoz jelsz
    * @param string $db_host adatbzis host
    * @param string $db_name adatbzis neve
    */
    public function __construct($db_user, $db_pwd, $db_host, $db_name)
    {
        $this->user   = $db_user;
        $this->pwd    = $db_pwd;
        $this->host   = $db_host;
        $this->dbname = $db_name;
    }

    /**
    * Felpti a kapcsolatot s belltja az adatbzist
    * 
    * @throws ha nem sikerl (MyException) kivtelt dob
    */
    public function connect()
    {
        $this->dbconnect = @mysql_pconnect($this->host, $this->user, $this->pwd);
        if (!is_resource($this->dbconnect)) {
            throw new MyException(DB_ERROR);
        }
        if (!@mysql_select_db($this->dbname, $this->dbconnect)) {
            throw new MyException(DB_ERROR);
        }
    }
    
    /**
    * Amennyiben a kapcsolat nem ltezik felpti
    * azt majd vgrehajtja a query-t.
    * 
    * @param string $query
    * @return object a query eredmnyvel meghvott DB_MysqlResult objektum (ha hiba trtnt 0)
    * @throws ha hiba trtnik (MyException) kivtelt dob
    */
    public function execute($query)
    {
        if (!$this->dbconnect) {
            $this->connect();
        }
        if (!$result = @mysql_query($query, $this->dbconnect)) {
            throw new MyException(DB_ERROR);
            return 0;
        } else {
            $rst = new DB_MysqlResult($result, $this->dbconnect, $query);
            return $rst;
        }
    }
}
  
/**
* Adatbzis kivonat (statement) kezel
* 
* (a rgi mysql extension-hz)
*/
class DB_MysqlResult
{
    /**
    * A query eredmnyt trolja
    * 
    * Csak sikeressen vgrehajtott query
    * eredmnyt trolja. SELECT esetn ez
    * egy erforrs. UPDATE, DELETE stb.
    * esetn viszont true rtk.
    * 
    * @see DB_Mysql::execute()
    * @var resource $result
    */
    protected $result;
    
    /**
    * A sikeresen vgrehajtott query-t trolja
    * 
    * @var string $query
    */
    public    $query;
    
    /**
    * Adatbzis kapcsolat
    * 
    * @var resource $dbconnect
    */
    protected $dbconnect;
    
    /**
    * Constructor
    * 
    * Betlti az Objektumot a query s a hozz
    * tartoz eredmnnyel. Ellenrzi, hogy
    * az adatbzis kapcsolat ltezik e.
    * 
    * @param resource $result a qurey-hez tartoz eredmny
    * @param resource $dbconnect adatbziskapcsolat
    * @param string $query
    * @throws ha a kapcsolat nem erforrs (resource) tipus
    *         (MyException) kivtelt dob
    */
    public function __construct($result, $dbconnect, $query) 
    {
        $this->result    = $result;
        $this->query     = $query;
        $this->dbconnect = $dbconnect;      
        if (!is_resource($dbconnect)) {
            throw new MyException(DB_ERROR);
        }
    }
    
    /**
    * A result kvetkez sorval, mint asszociatv tmbbel tr vissza
    * 
    * @return array a result egy sora mint tmb (ha nincs tbb sor false)
    */
    public function fetchAssoc()
    {
        return mysql_fetch_assoc($this->result);
    }
    
    /**
    * A result sszes sorval, mint asszociatv tmbbel tr vissza
    * 
    * @return array a result sszes sora mint tmb
    */
    public function fetchAllAssoc()
    {
        $rows = array();
        while ($row = $this->fetchAssoc()) {
            $rows[] = $row;
        }
        return $rows;
    }
    
    /**
    * A result sszes sornak kt (paramterben megadott) oszlopval,
    * mint asszociatv tmbbel tr vissza
    * 
    * @param string $key azon oszlopnak a neve melynek rtkei a rendezett tmb kulcsai lesznek
    * @param string $value azon oszlopnak a neve melynek rtkei a rendezett tmb elemei lesznek
    * @return array a result kt megadott oszlopnak minden sora mint (kulcs,rtk szerinti) tmb
    */
    public function fetchTwoColumnAssoc($key, $value)
    {
        $rows = array();
        while ($row = $this->fetchAssoc()) {
            $rows[$row[$key]] = $row[$value];
        }
        return $rows;
    }
    
    /**
    * A result felszabadtsa
    */
    public function freeResult()
    {
        mysql_free_result($this->result);
    }
    
}
?>