<?php

/**
* Fő rendszerbetöltő
*
* - A beállító file(ok) és Osztály(ok) csatolása
* - Változók inicializálása
* - PHP munkamenet kezelő indítása
* - A fő adatbázis kapcsolat ($dbh) megnyitása
* - Elindítja a felhasználó követő objektumot
* - A (kért) modul betöltése
* - A rendszer alap és a modulhoz tartozó szöveg állományának
*    $st-be (system_text-be) töltése
* - Felhasználói munkamenet indítása: azonosítja és
*    betőlti a felhasználót a Cookie-ja vagy a 
*    bejelentkezése alapján illetve kijelentkezteti.
* - Az eddigi műveletek hibakezelése (ha bármelyik előző
*    ponton hiba (kivétel dobódott) ide ugrik és itt
*    kezelődik le
* - A kért module includolása
* - A html template includolása
* 
* Rendszerkövetelmények: 
*   PHP 5.2, pdo, mcrypt
*   PEAR Image_Graph
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

//phpinfo();
//exit();

require_once 'config.php';
require_once './includes/Basic.inc';
require_once './includes/Admin.inc';
require_once './includes/DnD.inc';
require_once './includes/Forum.inc';
require_once './includes/Watchusers.inc';

$cookie = false;
$user = false;
$exceptions = array();
$menu_items = array();

session_name('TRATOKEN');
session_start();
header('Content-Type: text/html; charset=utf-8');
/* // Cache megszüntetése
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");              // múltbéli dátum
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // aktuális dátum
header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");                                    // HTTP/1.0
*/

try {
    $dbh = new PDO($pdo_dsn, $pdo_user, $pdo_pwd, $pdo_param);
    $dbh->query('SET NAMES utf8');
    
    $wu = new Watchusers();
    
    // A (kért) modul betöltése
    if (isset($_GET['module'])) {
        $module = $_GET['module'];
    } else {
        $module = $start_module;
    }
    $stmt = $dbh->prepare("SELECT * FROM modules WHERE name = ?");
    $stmt->execute(array($module));
    $module_property = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$module_property) {
        throw new SecException(SEC_ERROR, 0, $module);
    }
    
    // Szövegállomány betőltése
    $stmt = $dbh->prepare("SELECT name, ".ST_VALUE." 
                           FROM system_text
                           WHERE modules = 'main' OR
                                 modules = ?");
    $stmt->execute(array($module));
    $st = $stmt->fetchAll(PDO::FETCH_ASSOC|PDO::FETCH_COLUMN|PDO::FETCH_UNIQUE);
    
    // Felhasználói munkamenet indítása
    $cookie = new Cookie();
    if ($cookie->user_id !== false) {
        $cookie->valid();
        $user = new DnD_User($cookie->user_id);
        if (isset($_GET['logout'])) {
            $cookie->close();
            $cookie = false;
            $user = false;
            header('Location: '.$_SERVER['HTTP_REFERER']);
        }
    } elseif (isset($_POST['login_submit']) &&
              isset($_POST['login_name']) && isset($_POST['login_pwd'])) {
        $user = new DnD_User();
        $user->login($_POST['login_name'], $_POST['login_pwd']);
        $cookie = new Cookie($user->id);
        $cookie->set();
    } else {
    	$cookie = false;
    	$user = false;
    }
    
} catch (PDOException $e) {
    MyException::save($e);
    die(DB_ERROR.' ('.$e->getMessage().')');
} catch (SecException $e) {
    MyException::save($e);
    die($e->getMessage());
} catch (AuthException $e) {
    MyException::save($e);
    $cookie = false;
    $user = false;
} catch (Exception $e) {
    MyException::save($e);
}

$wu->setAuthParam($cookie);

// aszinkron (AJAX) action lista lekérésének kiszűrése
if (!isset($_GET['last_msg_id']) &&
    isset($_GET['ajax_up'])) {
    print "{'actions':'".$wu->getActions()."'}";
    exit();
}

include './modules/'.$module.'/index.php';

ob_start("ob_gzhandler");
include './themes/main/template.php';
ob_end_flush();

exit();

?>