/**
* JavaScript kódgyűjtemény
* 
* @package javascript
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

/**
 * (vékony)AJAX alrendszer, Effektek
 * 
 * Aszinkron-
 *   üzenetküldés és fogadás,
 *   keresés,
 *   felhasználók jelenléte és tevékenysége
 * 
 * Követelmény: jQuery > 1.2.6
 */
$(document).ready(function(){
	/**
     * AJAX státusz kijelző
     */
    $("#ajax_state").bind("ajaxSend", function(){
        $(this).show("slow");
    }).bind("ajaxComplete", function(){
		if ($(this).css("backgroundColor") != "red") {
			$(this).hide("slow");
		}
    }).bind("ajaxError", function(){
        $(this).hide("slow").css({ backgroundColor:"red" }).text('Ajjaj, hiba történt! Töltsd be újra az oldalt!');
    });
    
    /**
     * Indítási állapot felvétele (init)
     */
	var screen_res = screen.width+'*'+screen.height+' ['+document.documentElement.clientWidth+'*'+document.documentElement.clientHeight+']'; // felbontás (ha 0 akkor nem küldi aszinkron [ajax up])
	var screen_col = screen.colorDepth; // színmélység
	var change_msg = 1; // üzenet beviteli mező (textarea) nem változott (1 init)
    $('#spec_lsearch').hide(); // speciális keresés rejtett (def)
	$('#draft_messages').hide(); // tervezett üzenetek doboza rejtett (def)
	$('#searchmode_tip').hide(); // keresési mód tip box rejtett (def)
	
	// utolsó üzenet id értéke ha van
	if ($('#messages sup:first').text().split('#')[1]) {
		var last_msg_id = $('#messages sup:first').text().split('#')[1];
	}
	
	// Ha nincs tervezett üzenet, nem jeleníti meg a terv.üz. linket sem
	if ($('#draft_num').text() == '0') {
        $('#draft_tool').hide();
    }
	
	// Régi (2 ver.) Firefox-hoz kiegészítő css beállítása
	if (jQuery.browser.mozilla && jQuery.browser.version.substr(0,3) != "1.9") {
		$("label").css("display", "-moz-inline-box");
		$(".abutton").css("display", "-moz-inline-box");
	}
	
	/**
     * Böngésző (esemény) átméretezés
     */
	$(window).resize(function(){
        resized();
    });
	resized();
    function resized() {
		// dinamikus CSS értékek
        messages_width = document.documentElement.clientWidth-300;
        messages_tools_width = messages_width-315;
        $("#messages").css("width", messages_width+"px");
        $("#msg_tools").css("width", messages_tools_width+"px");
    }
	
    /**
     * Üzenet beviteli mezője (textarea) megváltozott (2)
     */
    $('#msg').keypress(function(){
        change_msg = 2;
    });
	
	/**
	 * Tervezett üzenetek dobozát elrejti/megjeleníti
	 */
    $('#draft_tool').click(function(){
        if ($('#draft_messages').is(":hidden")) {
            $('#draft_messages').slideDown("slow");
        } else {
            $('#draft_messages').slideUp("slow");
        }
    });
    
    /**
     * (AJAX) frissítő hívása
     * periódikusan (10 másodpercenként)
     */
    setInterval(updater,10000);
    
	/**
	 * (AJAX) Frissítő tevékenységek
	 *  -Üzenetek figyelése (aszinkron kezelés, autosave)
     *  -Azonosított felhasználók és tevékenységük
	 */
    function updater() {
		if ($('#messages sup:first').text().split('#')[1] &&
		    ($("#search").val() == '') &&
			(
			    !$("#labels_searchable").is(":checked") ||
			    (
				    $("#labels_searchable").is(":checked") && 
                    !$('#labels span').is('.selected')
				)
			) && $('#msgs_pager').val() == '0') {
            if (last_msg_id != 0) {
                last_msg_id = $('#messages sup:first').text().split('#')[1];
            } else if (last_msg_id == 0 && !$('#searchmode_tip').is(":hidden")) {
                searchmodeOff();
            }
			if (screen_res) {
				getdata = {'ajax_up':1,'last_msg_id':last_msg_id,'change_msg':change_msg,'screen_res':screen_res,'screen_col':screen_col};
				screen_res = 0;
			} else {
				getdata = {'ajax_up':1,'last_msg_id':last_msg_id,'change_msg':change_msg};
			}
        } else {
			if ($('#searchmode_tip').is(":hidden")) {
                searchmodeOn();
			}
			last_msg_id = 0;
			if (screen_res) {
                getdata = {'ajax_up':1,'screen_res':screen_res,'screen_col':screen_col};
                screen_res = 0;
            } else {
                getdata = {'ajax_up':1};
            }
        }
		
        $.getJSON(window.location.href, getdata,
		    function(res){
				// Action box újraírása
                $('#usrs_action').replaceWith(res.actions);
				// [Community modul] Új üzenet beszúrása és a lejárt üzenet visszavonási lehetőség eltüntetése
                if (res.newmsgs && res.newmsgs != '') {
                    if ($('#msg_modify').text()) {
                        $('#msg_modify').remove();
                    }
					if (last_msg_id == 0) {
                        $('#messages').html(res.newmsgs).hide().slideDown('slow');
                        last_msg_id = $('#messages sup:first').text().split('#')[1];
                    } else {
                        $('#messages p:first').before(res.newmsgs).hide().slideDown('slow');
                    }
                } else if ($('#messages p:first .msg_time').text().split(' ')[1] == 'perce') {
                    if (parseInt($('#messages p:first .msg_time').text().split(' ')[0]) > 15) {
                        $('#msg_modify').remove();
                    }
                } else if ($('#messages p:first .msg_time').text().split(' ')[1] != 'most') {
                    $('#msg_modify').remove();
                }
				// [Community modul] Az esetlegesen viszavont üzenetek tájékoztató törlése
				if (res.repealmsgid && res.repealmsgid != '') {
					var repealmsgid = res.repealmsgid.split(',');
					for (var i = 0; i < repealmsgid.length; i++) {
						$("#messages sup:contains('"+repealmsgid[i]+"'):first").parent().parent().next().html('<span class="comment">Sajnálom de ezt a bejegyzést a beírója visszavonta! Amennyiben csak módosítani akarta hamarosan olvashatod az új változatot!</span>');
					}
				}
            }
        );
        change_msg = 1;
    }
	
    /**
     * Percenkénti üzenet idő modosítás
     */
    setInterval(function() {
        $('.msg_time').each(function(i){
            time = $(this).text().split(' ');
            if (time[1] == 'perce') {
                inttime = parseInt(time[0]);
                if (inttime > 59) {
                    $(this).text('1 órája');
                } else {
                    $(this).html((inttime+1)+' '+time[1]);
                }
            } else if (time[1] == 'most') {
                $(this).text('1 perce');
            }
        });
    }, 60000);
	
	/**
	 * Autosave - 10 percenként menti az üzenetet tervezettként
	 * 
	 * Az első mentés 10-20 precen belül történik meg,
	 * ez után 10 perces periódusokban ismétlődik ha nincs
	 * bekapcsolva a keresési mód
	 */
	var autosave_on = 0;
	var prev_msg = '';
	setInterval(function() {
		if ($('#msg_autosave').is(':checked') &&
            $('#msg').val() != '' &&
			prev_msg != $('#msg').val() &&
			($('#messages sup:first').text().split('#')[1] &&
            ($("#search").val() == '') &&
            (
                !$("#labels_searchable").is(":checked") ||
                (
                    $("#labels_searchable").is(":checked") && 
                    !$('#labels span').is('.selected')
                )
            ) && $('#msgs_pager').val() == '0')) {
		  	if (autosave_on) {
				prev_msg = $('#msg').val();
                saveMsg('autosave');
			}
			autosave_on++;
        }
	}, 600000);
    
    /**
     * Óránkénti üzenet idő modosítás
     */
    setInterval(function() {
        $('.msg_time').each(function(i){
            time = $(this).text().split(' ');
            if (time[1] == 'órája') {
                $(this).text((parseInt(time[0])+1)+' '+time[1]);
            }
        });
    }, 3600000);
    
    /**
     * Tervezett üzenet kijelölése szerkesztésre vagy törlésre
     */
    $('#draft_messages').click(function(event){
		if ($(event.target).attr('id').split('_')[0] == 'msgdelete') {
			var del_id = $(event.target).parent().attr('id').split('_')[1];
			if (confirm('Törlöd a '+del_id+'-s beírást?')) {
				$.getJSON(window.location.href, {
					'delete_msg': 1,
					'msg_id': del_id
				}, function(res) {
					if (res.state == 'deleted_draft') {
						$('#draft_' + del_id).remove();
						$('#draft_num').text($('#draft_messages p').length).slideDown('slow');
						if ($('#msg_id').text() == del_id) {
							$('#msg_id').text('');
                            $('#msg').val('');
                            $('#msg_labels').val('');
                            $('#labels span').removeClass("selected");
						}
					}
				});
			}
		} else if (!$(event.target).hasClass('draft_act') &&
		           !$(event.target).parent().hasClass('draft_act')) {
			swapMsg(event);
		}
	});
    
    /**
     * Üzenet gyors visszavonása
     * (átminősítés tervezett üzenetek közé)
     */
    $('#messages').click(function(event){
        if ($(event.target).attr('id') == 'msg_modify') {
			repealmsg_id = $(event.target).prev().text().split('#')[1];
			$.getJSON(window.location.href, {
                    'repeal_msg': 1,
                    'msg_id': repealmsg_id
                },
                function(res){
                    if (res.state == 'repeal') {
                        $(event.target).parent().parent().next().html('<span class="comment">A bejegyzésedet fentebb módosíthatod és újra feladhatod (vagy elmentheted)! Addig is törölve lett!</span>');
                        $(event.target).replaceWith('<span>visszavonva</span>');
                    } else {
						// nem sikerült a visszavonás
                        if ($('#msg_modify').text()) {
                            $('#msg_modify').remove();
                        }
					}
                }
            );
			swapMsg(event);
        }
    });
    
	/**
	 * (AJAX) Egy adott üzenetet tölt be a beviteli form-ba
	 * ha van éppen írott üzenet a form-mezőben
	 * azt elmenti tervezettként
	 */
    function swapMsg(event) {
        if ($('#msg').val() != '') {
			var msg_id_act = $('#msg_id').text();
            $.post(window.location.href, {
				    'save_msg': $('#msg_id').text(),
				    'msg': $('#msg').val(),
				    'msg_labels': $('#msg_labels').val(),
				    'last_msg_id': last_msg_id
			    },
                function(res){
                    if (res.newmsgs != '') {
					    $('#draft_' + msg_id_act).remove();
						$('#draft_messages p:first').before(res.newmsgs).hide().slideDown('slow');
						$('#draft_num').text($('#draft_messages p').length).slideDown('slow');
                    }
                },
				"json"
			);
        }
		var msg_id;
        if ($(event.target).attr('id').split('_')[0] == 'draft') {
            msg_id = $(event.target).attr('id').split('_')[1];
			activateDraft(msg_id);
        } else if ($(event.target).parent().attr('id').split('_')[0] == 'draft') {
            msg_id = $(event.target).parent().attr('id').split('_')[1];
			activateDraft(msg_id);
        } else if ($(event.target).attr('id') == 'msg_modify') {
            msg_id = $('#messages sup:first').text().split('#')[1];
        } else {
            msg_id = last_msg_id;
        }
        $.getJSON(window.location.href, {
                'load_msg': 1,
                'msg_id': msg_id
		    },
            function(res){
                if (res.msg != '') {
                    $('#msg_id').text(res.msgid);
                    $('#msg_labels').val(res.msglabels);
                    $('#msg').val(res.msg);
					$('#labels span').removeClass("selected");
					var labels = res.msglabels.split(',');
					for (i in labels) {
					    $("#labels span:contains('"+labels[i]+"')").addClass("selected");
					}
                }
            }
        );
    }
	
	/**
	 * A tervezés alatt álló tervezett
	 * üzenetet jelöli meg a boxban
	 * 
	 * @param {Number} msg_id
	 */
	function activateDraft(msg_id) {
		if (msg_id != 'messages') {
			$('#draft_messages p').removeClass('draft_act');
            $('#draft_'+msg_id).addClass('draft_act');
		}
	}
    
    /**
     * (AJAX) Aszinkron elmenti az új üzenetet
     */
    $('#new_msg').click(function(event){
        $.post(window.location.href, {
                    'new_msg': $('#msg_id').text(),
                    'msg': $('#msg').val(),
                    'msg_labels': $('#msg_labels').val(),
                    'last_msg_id': last_msg_id
                },
                function(res){
                    if (res.newmsgs != '') {
                        $('#draft_'+$('#msg_id').text()).remove();
                        $('#draft_num').text($('#draft_messages p').length).slideDown('slow');
                        $('#msg_id').text('');
                        $('#msg').val('');
                        $('#msg_labels').val('');
                        $('#labels span').removeClass("selected");
                        if ($('#msg_modify').text()) {
                            $('#msg_modify').remove();
                        }
                        $('#messages p:first').before(res.newmsgs).slideDown('slow');
						last_msg_id = $('#messages sup:first').text().split('#')[1];
						autosave_on = 0;
                    }
                },
				"json"
        );
    });
    
	/**
	 * Üzenet mentésének indítása
	 */
	$('#save_msg').click(saveMsg);
	
    /**
     * (AJAX) Aszinkron elmenti az új üzenetet
     * a tervezettek közé
     * 
     * update - param 'autosave'
     */
	function saveMsg(event){
        $.post(window.location.href, {
                    'save_msg': $('#msg_id').text(),
                    'msg': $('#msg').val(),
                    'msg_labels': $('#msg_labels').val(),
                    'last_msg_id': last_msg_id
                },
                function(res){
                    if (res.newmsgs != '') {
                        $('#draft_' + $('#msg_id').text()).remove();
                        $('#draft_messages').prepend(res.newmsgs).hide().slideDown('slow');
                        $('#draft_num').text($('#draft_messages p').length).slideDown('slow');
                    }
					if (event == 'autosave') {
						act_darft = $('#draft_messages p').attr('id').split('_')[1];
						$('#msg_id').text(act_darft);
						activateDraft(act_darft);
					} else {
						$('#msg_id').text('');
						$('#draft_messages p').removeClass('draft_act');
                        $('#msg').val('');
                        $('#msg_labels').val('');
                        $('#labels span').removeClass("selected");
						autosave_on = 0;
					}
					$('#draft_tool').slideDown('slow');
                },
                "json"
        );
    }
    
    /**
     * Keresési műveletek alrendszer
     */
    $("#labels_searchable").click(changeSearch);
	$("#spec_lsearch input").click(changeSearch);
	$("#search_go").click(changeSearch);
	
	/**
	 * Érzékeli és kezelei a kiválasztott
	 * címkék és módok szerinti keresést
	 */
	function changeSearch(event) {
		if ($("#labels_searchable").is(":checked")) {
            $("#spec_lsearch").slideDown('slow');
			if ($('#labels span').is('.selected')) {
				var sellabels = $('#labels span.selected').get();
				var labels = [];
				for (var i = 0; i < sellabels.length; i++) {
					labels.push(sellabels[i].innerHTML);
				}
				searchLabels(labels);
			} else if(event.target.name == 'search_go') {
                var labels = [];
                searchLabels(labels);
            }
        } else if($("#search").val() != '') {
			var labels = [];
			searchLabels(labels);
			$("#spec_lsearch").slideUp('slow');
		} else {
            updater();
            $("#spec_lsearch").slideUp('slow');
        }
	}
	
	/**
     * Keresési mód kikapcsolása
     */
    $("#searchmodeoff").click(function(event){
        $('#search').val('');
        $('#labels_searchable').removeAttr("checked");
        $("#spec_lsearch").slideUp('slow');
        $('#msg_labels').val('');
        $('#labels span').removeClass("selected");
		$('#msgs_pager').val(0);
        searchmodeOff();
		updater();
    });
    function searchmodeOff() {
        $("#searchmode_tip").hide();
        if ($(".msg_alert").text() != 'Be kell jelentkezned!') {
            $("#msg").removeAttr("disabled");
            // $("#msg_labels").removeAttr("disabled");
            $("#save_msg").removeAttr("disabled");
            $("#new_msg").removeAttr("disabled");
        }
    }
    
    /**
     * Keresési mód bekapcsolása
     */
    function searchmodeOn() {
        $("#searchmode_tip").show();
        $("#msg").attr("disabled","disabled");
        // $("#msg_labels").attr("disabled","disabled");
        $("#save_msg").attr("disabled","disabled");
        $("#new_msg").attr("disabled","disabled");
    }
    
    /**
     * A címkék kijelölését kezeli
     */
    $('#labels span').click(function(event){
        if ($(this).is(".selected")) {
            $(this).removeClass("selected");
        } else {
            $(this).addClass("selected");
        }
        if (jQuery.trim($("#msg_labels").val()) == '') {
            var labels = [];
        } else {
            var labels = $("#msg_labels").val().split(',');
        }
        var length = labels.length;
        var sel_lab = jQuery.trim($(this).text());
        var is_newlabel = true;
        for (var i = 0; i < length; i++) {
            var buff = jQuery.trim(labels[i].toLowerCase());
            if (buff == sel_lab) {
                labels.splice(i,1);
                is_newlabel = false;
                break;
            } else {
                labels[i] = buff;
            }
        }
        if (is_newlabel) {
            labels.push(sel_lab);
        }
        $("#msg_labels").val(labels.join(', '));
        if ($("#labels_searchable").is(":checked")) {
			if ($('#labels span').is('.selected')) {
				searchLabels(labels);
			} else {
				last_msg_id = 0;
				updater();
			}
		}
    });
   
    /**
     * (AJAX) Aszinkron keresés megadott cimkékre és/vagy kulcsszavakra
     */
    function searchLabels(labels) {
        $.getJSON(window.location.href,
	            {
	   	            'search_labels':$("#spec_lsearch input[@name=labsearch_type]:checked").val(),
				    'labels':labels.join(' '),
					'words':$("#search").val()
				},
				function(res){
                    if (res.newmsgs != '') {
                        $('#messages').html(res.newmsgs);
                    }
                }
        );
    }
	
	/**
     * (AJAX) Aszinkron betölti a régi fórum oldalakat
     */
	$('#msgs_pager').change(function () {
        $.getJSON(window.location.href,
                {
                    'oldpage':$('#msgs_pager').val()
                },
                function(res){
                    if (res.newmsgs != '') {
                        $('#messages').html(res.newmsgs);
                    }
                }
        );
    }).change();
});

/**
* Alapefektek (JS)
*/
function initialize() {
    preloadImages();
	if (document.getElementById('gmap') && GBrowserIsCompatible()) {
        map = new GMap2(document.getElementById("gmap"));
		center = new GLatLng(47.5372624, 19.0887413);
        map.setCenter(center, 15);
        map.addControl(new GSmallMapControl());
		c_marker = new GMarker(center);
        GEvent.addListener(c_marker, "click", function() {
          c_marker.openInfoWindowHtml("<p>danworld</p>Én itt lakom!<p><a href=\"http://maps.google.com/maps/ms?ie=UTF&msa=0&msid=103664762408990111147.000438e73bfb30dec812a\">Megnézed a térképem?</a></p>");
        });
		map.addOverlay(c_marker);
    }
}

function preloadImages() {
    // főmenü
    mainmenu_img_kns = new Image();
    mainmenu_img_kns.src = "./themes/main/menu/kns_akt.jpg";
    mainmenu_img_yhuann = new Image();
    mainmenu_img_yhuann.src = "./themes/main/menu/yhuann_akt.jpg";
    mainmenu_img_dw = new Image();
    mainmenu_img_dw.src = "./themes/main/menu/dw_akt.jpg";
}

function img_change(id, new_picture)
{
    document.images[id].src = new_picture.src;
}

function text_change(id, new_text)
{
    document.getElementById(id).innerHTML = new_text;
}

function checkRadio(id_form, id_radio)
{
    if (document.getElementById(id_form).elements['defdragon'][id_radio].disabled == false) {
        document.getElementById(id_form).elements['defdragon'][id_radio].checked = true;
    }
}
