<?php

/**
* Közösségi oldal betöltője
* 
* @package Community
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2008 danworld page
*/

$content = './modules/Community/content.php';
$addchannel = '<li><a href="dat/rss.xml"><img src="./misc/rss_small.gif" alt="rss" /> RSS csatorna</a></li>';
$addheader = '<link rel="alternate" type="application/rss+xml" title="Kalandok és Sárkányok Fórum hírcsatornája" href="dat/rss.xml" />';

try {
    $frm = new Forum();
    if (isset($_GET['ajax_up']) &&
        isset($_GET['last_msg_id'])) {
        $response = array('actions'     => $wu->getActions(),
                          'newmsgs'     => $frm->getNewMsgs($_GET['last_msg_id']),
                          'repealmsgid' => $frm->getRepealMsgsId());
        print json_encode($response);
        exit();
    } elseif (isset($_POST['new_msg']) && 
              isset($_POST['msg']) &&
              isset($_POST['msg_labels']) &&
              isset($_POST['last_msg_id'])) {
        if ($user) {
        	$frm->insert($_POST['new_msg'], $_POST['msg'], $user->id, $_POST['msg_labels']);
        	$response = array('newmsgs' => $frm->getNewMsgs($_POST['last_msg_id']));
        	print json_encode($response);
        	$frm->loadMsgs();
            $frm->getMsgsXML();
        	exit();
        } else {
        	throw new SecException('{"newmsgs":"","error":"<div class=\"msg_warning\">'.$GLOBALS['st']['error_in_header'].'</div>"}');
        }
    } elseif (isset($_POST['save_msg']) &&
              isset($_POST['msg']) &&
              isset($_POST['msg_labels']) &&
              isset($_POST['last_msg_id'])) {
        if ($user) {
        	$frm->insert($_POST['save_msg'], $_POST['msg'], $user->id, $_POST['msg_labels'], 2);
        	$response = array('newmsgs' => $frm->getNewMsgs($_POST['last_msg_id']));
            print json_encode($response);
        	exit();
        } else {
        	throw new SecException('{"newmsgs":"","error":"<div class=\"msg_warning\">'.$GLOBALS['st']['error_in_header'].'</div>"}');
        }
    } elseif (isset($_GET['repeal_msg']) &&
              isset($_GET['msg_id'])) {
        if ($user) {
            print json_encode($frm->repealMsg($_GET['msg_id'], $user->id));
            exit();
        } else {
            throw new SecException('{"state":"","error":"<div class=\"msg_warning\">'.$GLOBALS['st']['error_in_header'].'</div>"}');
        }
    } elseif (isset($_GET['load_msg']) &&
              isset($_GET['msg_id'])) {
    	if ($user) {
            print json_encode($frm->getMsg($_GET['msg_id']));
        	exit();
        } else {
        	throw new SecException('{"newmsgs":"","error":"<div class=\"msg_warning\">'.$GLOBALS['st']['error_in_header'].'</div>"}');
        }
    } elseif (isset($_GET['search_labels']) &&
              isset($_GET['labels']) &&
              isset($_GET['words'])) {
    	$frm->loadSearchLabelsMsgs($_GET['labels'], $_GET['search_labels'], $_GET['words']);
    	$response = array('newmsgs' => $frm->getMsgs());
        print json_encode($response);
        exit();
    } elseif (isset($_GET['oldpage'])) {
        $frm->loadMsgs();
        $response = array('newmsgs' => $frm->getMsgs($_GET['oldpage']));
        print json_encode($response);
        exit();
    } elseif (isset($_GET['delete_msg']) &&
              isset($_GET['msg_id'])) {
        if ($user) {
            print json_encode($frm->deleteDraftMsg($_GET['msg_id'], $user->id));
            exit();
        } else {
            throw new SecException('{"state":"","error":"<div class=\"msg_warning\">'.$GLOBALS['st']['error_in_header'].'</div>"}');
        }
    }
    $frm->loadMsgs();
} catch (PDOException $e) {
    MyException::save($e);
    die(DB_ERROR.' ('.$e->getMessage().')');
} catch (SecException $e) {
    MyException::save($e);
    die($e->getMessage());
} catch (Exception $e) {
    MyException::save($e);
    die($e->getMessage());
}

?>