<?php

/**
* Html kód sablon
* 
* @package Main
* @version $Id$
* @author Kocsis Daniel <it.danworld@gmail.com>
* @copyright 2007 danworld page
*/

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="hu">

<head>

  <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
  <meta http-equiv="content-language" content="hu" />
  <meta name="author" content="dw Kocsis Daniel" />
  <meta name="keywords" content="<?php print $module_property['keywords']; ?>" />
  <meta name="description" content="<?php print $module_property['page_description']; ?>" />

  <title><?php print $st['danworld']." - ".$st[$module_property['pagetitle']]; ?></title>

  <style type="text/css" media="screen, projection">
    @import "./themes/main/main.css";
    @import "./themes/main/modules.css";
  </style>
  <!--[if IE]>
  <style type="text/css" media="screen, projection">
    @import "./themes/main/ie.css";
  </style>
  <![endif]-->

  <style type="text/css" media="print">
    #gmap {
      width:265px;
      height:250px;
      border: 2px solid #666666;
      color:#000000;
    }
  </style>

  <style type="text/css" media="handheld">
    img.as-text { content: attr(alt); }
    table, tbody, tr, td, th { display: block; }
    #gmap { display:none; }
  </style>

  <link rel="Shortcut Icon" type="image/x-icon" href="./misc/dw.ico" />
  <?php if(isset($addheader)) print $addheader; ?>

  <script src="./js/jquery.js" type="text/javascript"></script>
  <script src="./js/main.js" type="text/javascript"></script>

</head>

<!--

<?php print $st['develop_info']; ?>


-->

<body onload="initialize();">

<div id="main_container">
    
  <div id="ajax_state">Töltés...</div>

  <div id="head">
    <h1><span><?php print $st['dwwebpage']; ?></span></h1>
    <ul>
      <?php if ($module == 'danworld' or $module == 'Yhuann' or $module == 'Registration'): ?><li id="mm_1">
        <a href="index.php?module=danworld" onmouseover="img_change('mainmenu_akt_img',mainmenu_img_dw); text_change('akt_menu_item','<?php print $st['danworld']; ?>');">
          <img src="./themes/main/menu/dw.png" alt="<?php print $st['dw']; ?>" title="<?php print $st['dw']; ?>" width="25" height="25" />
          <span><?php print $st['danworld']; ?></span>
        </a>
      </li><?php endif; ?>
      <li id="mm_2">
        <a href="index.php?module=Yhuann" onmouseover="img_change('mainmenu_akt_img',mainmenu_img_yhuann); text_change('akt_menu_item','<?php print $st['yhuann']; ?>');">
          <img src="./themes/main/menu/yhuann.png" alt="<?php print $st['yhuann']; ?>" title="<?php print $st['yhuann']; ?>" width="25" height="25" />
          <span><?php print $st['yhuann']; ?></span>
        </a>
      </li>
      <?php if ($module != 'danworld' && $module != 'Yhuann' && $module != 'Registration'): ?><li id="mm_3">
        <a href="index.php?module=Community" onmouseover="img_change('mainmenu_akt_img',mainmenu_img_kns); text_change('akt_menu_item','<?php print $st['kns']; ?>');">
          <img src="./themes/main/menu/kns.png" alt="<?php print $st['kns']; ?>" title="<?php print $st['kns']; ?>" width="25" height="25" />
          <span><?php print $st['kns']; ?></span>
        </a>
      </li><?php endif; ?>
    </ul>
    <div id="mainmenu_akt">
      <img id="mainmenu_akt_img" src="./themes/main/menu/kns_akt.jpg" alt="Aktuális oldal" />
      <span id="akt_menu_item"><?php print $st[$module_property['title_h2']]; ?></span>
    </div>
  </div>

  <div id="user_frame"><?php if ($user) : ?>
    <div id="user_tools">
      <h4><span><?php print $user->name." ".$st['s_toolbar']; ?></span></h4>
      <img src="./misc/defdragons/medium/<?php print $user->defdragon; ?>.png" alt="<?php print $st[$user->defdragon]; ?>" title="<?php print $st[$user->defdragon]; ?>" width="60" height="60" />
      <form action="<?php print $_SERVER['REQUEST_URI']; ?>" method="post">
        <ul class="button">
          <li><a class="abutton" href="index.php?logout=1"><?php print $st['logout']; ?></a></li>
        </ul>
      </form>
    </div>
                       <?php else: ?>
    <div id="user_tools">
      <h4><span><?php print $st['login']; ?></span></h4>
      <form action="<?php print $_SERVER['REQUEST_URI']; ?>" method="post">
        <p><label for="login_name"><?php print $st['user']; ?>:</label>
        <input type="text" name="login_name" id="login_name" /></p>
        <p><label for="login_pwd"><?php print $st['pwd']; ?>:</label>
        <input type="password" name="login_pwd" id="login_pwd" />
        <input type="submit" name="login_submit" id="login_submit" value="<?php print $st['login_submit']; ?>" /></p>
        <ul class="button">
          <li><a class="abutton" href="index.php?module=Registration"><?php print $st['registration']; ?></a></li>
          <li><a class="abutton" href="index.php?module=Registration&amp;entererr=1"><?php print $st['not_allow_login']; ?></a></li>
        </ul>
      </form>
    </div>
                       <?php endif;
                             MyException::getExceptions();
                             print $wu->getActions(); ?>
    <div id="channel">
      <h4 class="hide">Csatornák</h4>
      <ul>
        <li><a href="index.php?module=Lite"><img src="./misc/rss_small.gif" alt="lite" /> lite csatorna (kis sávszélességhez)</a></li>
        <?php if (isset($addchannel)) print $addchannel; ?>
      </ul>
    </div>
    
    <div>
      <h4 class="hide">Infó</h4>
      <a href="index.php?module=danworld">A weboldalról...</a>
    </div>
    
  </div>

  <div id="content_frame">
  
    <div id="menu">
    
      <?php if ($module_property['object_h']): ?><h2 style="background: url(./themes/main/<?php print $module_property['object_h']; ?>) no-repeat top center;"><span id="with_object"><?php print $st[$module_property['title_h2']]; ?></span></h2>
      <?php else: ?><h2><span><?php print $st[$module_property['title_h2']]; ?></span></h2>
      <?php endif;
            if ($module_property['menu_text']): ?><h4><span><?php print $st[$module_property['menu_text']]; ?></span></h4>
      <?php endif;
            if ($module_property['menu_items']):
                $menu_items = explode(', ', $module_property['menu_items']); ?><h4 id="menu_title"><span><?php print $st['menu']; ?></span></h4>
      <ul>
      
        <?php foreach ($menu_items as $id => $module): 
                if (strstr($module,':')): $link = explode(':', $module, 2) ?><li><a href="<?php print $link[1]; ?>"><strong><?php print $st[$link[0]]; ?></strong></a></li>
          <?php else: ?><li><a href="index.php?module=<?php print ucfirst($module); ?>"><strong><?php print $st[$module]; ?></strong></a></li>
          <?php endif; ?>
        <?php endforeach; ?>
        
      </ul>
      <?php endif; ?>
      
    </div>

    <div id="<?php print $module_property['content_type']; ?>_content">
<?php if ($module_property['title_h3']): ?>
      <h3><span><?php print $st[$module_property['title_h3']]; ?></span></h3>
<?php endif;
      include_once $content; ?>

    </div>
    
  </div>

</div>

</body>

</html>