<?php   

define('ERROR_MSG','Hiba történt! ');

error_reporting(E_ALL | E_STRICT);
ini_set('display_startup_errors', 1);
ini_set('display_errors', 1);
ini_set('default_charset','utf-8');

set_include_path('../library'.PATH_SEPARATOR.get_include_path());

// LOADER
require_once 'Zend/Loader.php';
Zend_Loader::registerAutoload();

// CONFIG
$config = new Zend_Config_Ini('../application/config.ini.php','production');

// LAYOUT
Zend_Layout::startMvc();

// CACHE
$frontendOptions = array('lifetime' => 7200, // 2 óra
                         'automatic_serialization' => true);
$backendOptions  = array('cache_dir' => '../cache/');
$cache = Zend_Cache::factory('Core', 'File', $frontendOptions, $backendOptions);

// DB
$db = Zend_Db::factory($config->database);
$db->query('SET NAMES utf8');

// DB_Table
require_once '../application/models/DB_Tables_Inc/Tables.php';

// MODELS
require_once '../application/models/Property/prop_xml.php';

// CONTROLLER

$request = new Zend_Controller_Request_Http();
if ($request->isXmlHttpRequest()) {
	require_once '../application/models/Ajax_Connector/set_props.php';
	exit();
}

$frontController = Zend_Controller_Front::getInstance();
$frontController->throwExceptions(true);
$frontController->setControllerDirectory('../application/controllers');
$frontController->dispatch();