<?php

class IndexController extends Zend_Controller_Action
{
    public function init()
    {
        $ajaxContext = $this->_helper->getHelper('AjaxContext');
        $ajaxContext->addActionContext('view', 'html')
                    ->addActionContext('form', 'html')
                    ->addActionContext('process', 'json')
                    ->initContext();
        /*$ajaxContext = $this->_helper->getHelper('AjaxContext');
        $ajaxContext->addActionContext('validate', 'json')
                    ->initContext();*/
        // link: http://devzone.zend.com/article/1280-AJAX-Chat-Tutorial-Part-2Prototype-Scriptaculous-Application-HTML
        //echo "JSON:";
        //echo Zend_Json::encode(get_object_vars($this));
    }
    
    public function indexAction()
    {
        $this->_forward('office');
    }
    
    public function officeAction()
    {
        $this->_helper->actionStack('menu','nav');
        $search_form = $this->getSearchForm();
        $edit_prop = $this->editPropForm();
        
        if ($this->getRequest()->isPost()) {
            if ($edit_prop->isValid($_POST)) {
                $add_prop = $edit_prop->getValues();
                $datasheet = new Datasheet();
                $edit_data = array('map_lat' => $add_prop['adress_lat'],
                                  'map_lng' => $add_prop['adress_lng']);
                $where = $datasheet->getAdapter()->quoteInto('id = ?', $add_prop['prop_id']);
                $datasheet->update($edit_data, $where);
                $this->view->add_prop = $add_prop;
            }
        }
        
        $this->view->search_form = $search_form;
        $this->view->edit_prop = $edit_prop;
        $this->view->property_list = $this->getPropertyList();
    }
    
    public function validateAction()
    {
        echo "JSON!!";
        if ($this->getRequest()->isPost())
        {
            $data = $this->editPropForm()->processAjax($_POST);
            $this->_helper->json->sendJson($data);
        }
    }

    /**
    * Kereső mező
    */
    public function getSearchForm()
    {
        $form = new Zend_Form();
        $form->setName('SearchPropForm');
        $search_box = $form->createElement('text', 'search_box');
        $search_box->setLabel('keresés')
                   ->setAttrib('onKeyUp', 'searchId()');
        $form->addElement($search_box);
        return $form;
    }
    
    /**
    * Új ingatlan felvétele/Módosítás
    */
    public function editPropForm()
    {
        $prop_defs = new Property_XML();
        $form = new Zend_Form();
        $form->setName('editPropForm')
             ->setAction('./')
             ->setMethod('post');
        $prop_id = $form->createElement('text', 'prop_id');
        $prop_id->setLabel('Azonosítószám')
                ->addValidator('digits')
                ->setRequired(true);
        $elems = array('igen','nem');
        $type      = $form->createElement('select',
                                          'type',
                                          array('label'=>'Az ingatlan',
                                                'multiOptions'=>array(
                                                    '1'=>'eladó',
                                                    '2'=>'kiadó',
                                                    '3'=>'eladó és kiadó'),
                                                'value'=>'1'));
        $type_2    = $form->createElement('select',
                                          'type_2',
                                          array('label'=>'tipusa',
                                                'multiOptions'=>array(
                                                    '1'=>'használt',
                                                    '2'=>'ÚJÉPÍTÉSŰ'),
                                                'value'=>'1'));
        $type_main_elems = $prop_defs->type_main;
        $type_main = $form->createElement('select',
                                          'type_main',
                                          array('label'=>'kategóriája',
                                                'multiOptions'=>$type_main_elems,
                                                'value'=>'1'));
        $is_active = $form->createElement('radio',
                                          'is_active',
                                          array('label'=>'jelenleg legyen',
                                                'multiOptions'=>array(
                                                    '1'=>'aktív.',
                                                    '0'=>'most nem aktív.'),
                                                'value'=>'1'));
        $type_city_elems = $prop_defs->type_city;
        $type_city = $form->createElement('select',
                                          'type_city',
                                          array('label'=>'Elhelyezkedése',
                                                'multiOptions'=>$type_city_elems,
                                                'value'=>'0'));
        $adress_postcode = $form->createElement('text', 'adress_postcode');
        $adress_postcode->setLabel('irányítószám')
                        ->setAttrib('onKeyUp', 'sendGmap()')
                        ->addValidator('digits')
                        ->addValidator('stringLength', false, array(4, 4))
                        ->setRequired(true);
        $adress_description = $form->createElement('text', 'adress_description');
        $adress_description->setLabel('utca neve')
                           ->setAttrib('onChange', 'sendGmap()')
                           //->addValidator('alnum')
                           //->addValidator('regex', false, array('/^[a-z]+/'))
                           ->addValidator('stringLength', false, array(0, 100))
                           ->setRequired(true);
        $adress_number = $form->createElement('text', 'adress_number');
        $adress_number->setLabel('házszám')
                      ->setAttrib('onKeyUp', 'sendGmap()')
                      ->setRequired(true);
        $adress_lat = $form->createElement('text', 'adress_lat');
        $adress_lat->setLabel('kordináta x')
                   ->setRequired(true);
        $adress_lng = $form->createElement('text', 'adress_lng');
        $adress_lng->setLabel('kordináta y')
                   ->setRequired(true);
        $form->addElement($prop_id)
             ->addElement($type)
             ->addElement($type_2)
             ->addElement($type_main)
             ->addElement($is_active)
             ->addElement($type_city)
             ->addElement($adress_postcode)
             ->addElement($adress_description)
             ->addElement($adress_number)
             ->addElement($adress_lat)
             ->addElement($adress_lng)
             ->addElement('submit', 'bevitel', array('label' => 'bevitel'));
        return $form;
    }
    
    /**
    * Ingatlan lista
    */
    public function getPropertyList()
    {
        $datasheet = new Datasheet();
        /*$select = $datasheet->select()->where('id = ?', '473')
                                      ->order('id');*/
        /*$rowset = $datasheet->find(98);
        $res = $rowset->current();
        $select = $datasheet->select()->order('id');
        $result = $res->findDependentRowset('Type_main', 'TypeMain', $select);
        $result = $result->toArray();
        print_r($result);*/
        $result = $datasheet->fetchAll();
        $result = $result->toArray();
        return $result;
    }
}