/**
 * Ingatlanok
 * 
 * ajax, gmap, dlist, search
 * 
 * @author dw
 */

var map;
var response;
var p_data;
var gcg;
var propertys;

function initialize() {
    if (GBrowserIsCompatible()) {
        map = new GMap2(document.getElementById("gmap"));
        map.setCenter(new GLatLng(47.56, 19.12), 12);
        map.addControl(new GLargeMapControl());
        map.addControl(new GMapTypeControl());
        map.addControl(new GOverviewMapControl());
        map.addControl(new google.maps.LocalSearch(), new GControlPosition(G_ANCHOR_BOTTOM_LEFT, new GSize(10,20)));
        gcg = new GClientGeocoder();
        loadProps(1, 'setProps');
    } else {
        alert('A böngésző verziója nem támogatott, így az oldal nem képes megfelelően működni! Sajnálom...');
    }
}
GSearch.setOnLoadCallback(initialize);

function loadProps(params, callSucces) {
    var requestUrl = './';
    try {
        var request = new Ajax.Request(
            requestUrl,
            {
                method: 'post',
                parameters: 'getProps='+params,
                onUninitialized: function() {
                    $('mini_msg').innerHTML = 'Ajax Uninitialized';
                },
                onLoading: function() {
                    $('mini_msg').innerHTML = 'Ajax Loading';
                },
                onLoaded: function() {
                    $('mini_msg').innerHTML = 'Ajax. Loaded';
                },
                onInteractive: function() {
                    $('mini_msg').innerHTML = 'Ajax.. Interactive';
                },
                onComplete: eval(callSucces)
            }
        );
    } catch (e) {
        $('mini_msg').innerHTML = 'Hiba az Ajax rendszerben! ' + e.toString();
    }
}

function setProps(response) {
    $('mini_msg').innerHTML = 'Ajax... Complete';
    $('ajax_response').value = response.responseText;
                    
    propertys = eval('('+response.responseText+')');
    propsOnMap();
}

function hitId(response) {
    $('mini_msg').innerHTML = 'Ajax... Complete';
    $('ajax_response').value = response.responseText;
                    
    fillDlist(response.responseText);
}

function searchId() {
    if ($F('search_box').length > 4) {
        loadProps(2+'&searchAdvId='+$F('search_box'), 'hitId');
    } else {
        fillDlist(0);
    }
}

function getMarker(lat, lng) {
    map.clearOverlays();
    var latlng = new GLatLng(lat, lng);
    var marker = new GMarker(latlng);
    map.addOverlay(marker);
}

function fillDlist(hitid) {
    var i = 0;
    var dtable = '<table>';
    dtable += '<tr class="row_h"><th>azon.</th><th>cím</th><th>típus</th><th>méret</th><th>telek</th><th>sz.</th><th>ár</th><th>dátum</th><th>tulajdonos</th><th>telefon</th></tr>';
    for (var id in propertys) {
        var reg = new RegExp('^'+$F('search_box')+'+');
        if (reg.test(id) || id == hitid) {
      		i++;
      		if ((i%2) == 0) row_class=' class="row_strong"'; else row_class='';
            dtable += '<a href="#"><tr'+row_class+' onClick="getMarker('+propertys[id].map_lat+','+propertys[id].map_lng+')">';
            dtable += '<td>' + id + '</td>';
            dtable += '<td>' + propertys[id].adress + '</td>';
            dtable += '<td>' + propertys[id].type_main + '</td>';
            dtable += '<td>' + propertys[id].area_base + '</td>';
            dtable += '<td>' + propertys[id].area_parcel + '</td>';
            dtable += '<td>' + propertys[id].rooms + '</td>';
            dtable += '<td>' + propertys[id].cost + '</td>';
            dtable += '<td>' + propertys[id].reg_date + '</td>';
            dtable += '<td>' + propertys[id].owners + '</td>';
            dtable += '<td>' + propertys[id].tel + '</td>';
            dtable += '</tr><a>';
        }
    }
    dtable += '</table>';
    $('dlist').innerHTML = dtable;
}

function propsOnMap() {
    for (var id in propertys) {
        var pointIcon = new GIcon(G_DEFAULT_ICON);
        pointIcon.image = 'img/marker-point1.png';
        pointIcon.shadow = 'img/marker-point1-shadow2.png';
        //pointIcon.iconSize = new GSize(10, 10);
        /*pointIcon.shadowSize = new GSize(37, 34);
        pointIcon.iconAnchor = new GPoint(9, 34);
        pointIcon.infoWindowAnchor = new GPoint(9, 2);
        pointIcon.infoShadowAnchor = new GPoint(18, 25);*/
        var latlng = new GLatLng(propertys[id].map_lat, propertys[id].map_lng);
        var markerOptions = { icon:pointIcon, title: id + " - " + propertys[id].adress };
        var marker = new GMarker(latlng, markerOptions);
        map.addOverlay(marker);
    }
}

/*
function sendNewProp() {
    var requestUrl = 'index/newprop';
    var newprop = $F('adress_postcode') +
                  $F('adress_description') +
                  $F('adress_number');
    try {
        var request = new Ajax.Request(
            requestUrl,
            {
                method: 'get',
                parameters: 'adress=' + encodeURIComponent(newprop),
                onComplete: setNewMarker
            }
        );
    } catch (e) {
        alert('Hiba az Ajax rendszerben! ' + e.toString());
    }
}

function setNewMarker(reply) {
    alert('Válasz: ' + reply.responseText);
}*/

function sendGmap() {
    if ($F('adress_postcode').length == 4) {
        var p_data = $F('adress_postcode') + " " +
                     $F('adress_description') + " " +
                     $F('adress_number');
        map.clearOverlays();
        gcg.getLatLng(p_data, function(point) {
    	    if (!point) {
                $('msg').innerHTML = 'A ' + p_data + ' nem található!';
    	    } else {
                $('msg').innerHTML = 'A ' + p_data + ' helyét megtekintheti a térképen.';
        	    var markerOptions = { title: p_data, 
                                      draggable: true };
                var newp_marker = new GMarker(point, markerOptions);
                map.addOverlay(newp_marker);
                GEvent.addListener(newp_marker, 'mouseover', function() {
            	    newp_marker.openInfoWindowHtml(p_data);
                });
                $('adress_lat').value = point.lat();
                $('adress_lng').value = point.lng();
            }
        });
        var status = gcg.GGeoStatusCode();
        alert('Status: '+status);
    } else {
        $('msg').innerHTML = 'Minden adatot érdemes megadni!';
    }
}

function setActProp(prop_id, adress_postcode, adress_description, adress_number) {
    $('prop_id').value = prop_id;
    $('adress_postcode').value = adress_postcode;
    $('adress_description').value = adress_description;
    $('adress_number').value = adress_number;
    sendGmap();
}

function editProp() {
    
}

/* speciális jelölő
function createMarker(point) {
    var baseIcon = new GIcon();
        baseIcon.shadow = "http://www.google.com/mapfiles/shadow50.png";
        baseIcon.iconSize = new GSize(20, 34);
        baseIcon.shadowSize = new GSize(37, 34);
        baseIcon.iconAnchor = new GPoint(9, 34);
        baseIcon.infoWindowAnchor = new GPoint(9, 2);
        baseIcon.infoShadowAnchor = new GPoint(18, 25);
    
    var letter = String('I');
    var letteredIcon = new GIcon(baseIcon);
    letteredIcon.image = "http://www.google.com/mapfiles/marker" + letter + ".png";

    markerOptions = { title:p_data, icon:letteredIcon };
    //alert(p_data);
    var marker = new GMarker(point, markerOptions);
    
    GEvent.addListener(marker, "click", function() {
        marker.openInfoWindowHtml(p_data);
    });
    return marker;
}
*/